/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitPrecision;

public class ExplicitReducer
implements Reducer {
    private boolean occursInBlock(Block pBlock, String pVar) {
        for (ReferencedVariable referencedVar : pBlock.getReferencedVariables()) {
            if (!referencedVar.getName().equals(pVar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractElement getVariableReducedElement(AbstractElement pExpandedElement, Block pContext, CFANode pCallNode) {
        ExplicitElement expandedElement = (ExplicitElement)pExpandedElement;
        ExplicitElement clonedElement = expandedElement.clone();
        for (String trackedVar : expandedElement.getTrackedVariableNames()) {
            if (this.occursInBlock(pContext, trackedVar)) continue;
            clonedElement.deleteValue(trackedVar);
        }
        return clonedElement;
    }

    @Override
    public AbstractElement getVariableExpandedElement(AbstractElement pRootElement, Block pReducedContext, AbstractElement pReducedElement) {
        ExplicitElement rootElement = (ExplicitElement)pRootElement;
        ExplicitElement reducedElement = (ExplicitElement)pReducedElement;
        ExplicitElement diffElement = rootElement.clone();
        for (String trackedVar : reducedElement.getTrackedVariableNames()) {
            diffElement.deleteValue(trackedVar);
        }
        for (String trackedVar : reducedElement.getTrackedVariableNames()) {
            Long value = reducedElement.getValueFor(trackedVar);
            if (value != null) {
                diffElement.assignConstant(trackedVar, reducedElement.getValueFor(trackedVar));
                continue;
            }
            diffElement.forget(trackedVar);
        }
        return diffElement;
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        ExplicitPrecision precision = (ExplicitPrecision)pPrecision;
        return precision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        ExplicitPrecision reducedPrecision = (ExplicitPrecision)pReducedPrecision;
        return reducedPrecision;
    }

    @Override
    public Object getHashCodeForElement(AbstractElement pElementKey, Precision pPrecisionKey) {
        ExplicitElement elementKey = (ExplicitElement)pElementKey;
        ExplicitPrecision precisionKey = (ExplicitPrecision)pPrecisionKey;
        return Pair.of(elementKey.getConstantsMap(), (Object)precisionKey);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        return 0;
    }
}

