/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitCPA;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitPrecision;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitTransferRelation;
import org.sosy_lab.cpachecker.cpa.explicit.PredicateMap;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefinementManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.interpolation.AbstractInterpolationBasedRefiner;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

@Options(prefix="cpa.predicate")
public class ExplicitRefiner
extends AbstractInterpolationBasedRefiner<Collection<AbstractionPredicate>, Pair<ARTElement, CFANode>> {
    final Timer precisionUpdate = new Timer();
    final Timer artUpdate = new Timer();
    private Pair<ARTElement, CFANode> firstInterpolationPoint = null;
    private Set<String> allReferencedVariables = new HashSet<String>();
    private Set<String> globalVars = null;
    private final ExtendedFormulaManager fmgr;
    private final PathFormulaManager pathFormulaManager;
    private boolean predicateCpaAvailable = false;
    private Set<Integer> pathHashes = new HashSet<Integer>();
    private Integer previousPathHash = null;
    private boolean refinePredicatePrecision = false;
    private List<Pair<ARTElement, CFAEdge>> path = null;
    private static final Function<PredicateAbstractElement, Formula> GET_BLOCK_FORMULA = new Function<PredicateAbstractElement, Formula>(){

        public Formula apply(PredicateAbstractElement e) {
            assert (e.isAbstractionElement());
            return e.getAbstractionFormula().getBlockFormula();
        }
    };

    public static ExplicitRefiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(ExplicitRefiner.class.getSimpleName() + " could not find the ExplicitCPA");
        }
        ExplicitCPA explicitCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(ExplicitCPA.class);
        if (explicitCpa == null) {
            throw new InvalidConfigurationException(ExplicitRefiner.class.getSimpleName() + " needs a ExplicitCPA");
        }
        ExplicitRefiner refiner = ExplicitRefiner.initialiseExplicitRefiner(pCpa, explicitCpa.getConfiguration(), explicitCpa.getLogger());
        return refiner;
    }

    private static ExplicitRefiner initialiseExplicitRefiner(ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger) throws CPAException, InvalidConfigurationException {
        boolean predicateCpaInUse;
        FormulaManagerFactory factory = null;
        ExtendedFormulaManager formulaManager = null;
        PathFormulaManager pathFormulaManager = null;
        Solver solver = null;
        AbstractionManager absManager = null;
        PredicateRefinementManager manager = null;
        PredicateCPA predicateCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(PredicateCPA.class);
        boolean bl = predicateCpaInUse = predicateCpa != null;
        if (predicateCpaInUse) {
            factory = predicateCpa.getFormulaManagerFactory();
            formulaManager = predicateCpa.getFormulaManager();
            pathFormulaManager = predicateCpa.getPathFormulaManager();
            solver = predicateCpa.getSolver();
            absManager = predicateCpa.getAbstractionManager();
        } else {
            factory = new FormulaManagerFactory(config, logger);
            TheoremProver theoremProver = factory.createTheoremProver();
            RegionManager regionManager = BDDRegionManager.getInstance();
            formulaManager = new ExtendedFormulaManager(factory.getFormulaManager(), config, logger);
            pathFormulaManager = new PathFormulaManagerImpl(formulaManager, config, logger);
            solver = new Solver(formulaManager, theoremProver);
            absManager = new AbstractionManager(regionManager, formulaManager, config, logger);
        }
        manager = new PredicateRefinementManager(formulaManager, pathFormulaManager, solver, absManager, factory, config, logger);
        return new ExplicitRefiner(config, logger, pCpa, formulaManager, pathFormulaManager, manager, predicateCpaInUse);
    }

    protected ExplicitRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis pCpa, ExtendedFormulaManager pFmgr, PathFormulaManager pPathFormulaManager, PredicateRefinementManager pInterpolationManager, boolean predicateCpaInUse) throws CPAException, InvalidConfigurationException {
        super(config, logger, pCpa, pInterpolationManager);
        config.inject((Object)this, ExplicitRefiner.class);
        this.fmgr = pFmgr;
        this.pathFormulaManager = pPathFormulaManager;
        this.predicateCpaAvailable = predicateCpaInUse;
        this.globalVars = ExplicitTransferRelation.globalVarsStatic;
    }

    @Override
    protected void performRefinement(ARTReachedSet pReached, List<Pair<ARTElement, CFANode>> errorPath, CounterexampleTraceInfo<Collection<AbstractionPredicate>> counterexampleTraceInfo, boolean pRepeatedCounterexample) throws CPAException {
        this.precisionUpdate.start();
        if (!this.hasMadeProgress()) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, null);
        }
        ReachedSet reached = pReached.asReachedSet();
        Precision oldPrecision = reached.getPrecision(reached.getLastElement());
        Pair<ARTElement, Precision> refinementResult = this.performRefinement(oldPrecision, errorPath, counterexampleTraceInfo);
        this.precisionUpdate.stop();
        this.artUpdate.start();
        ARTElement root = (ARTElement)refinementResult.getFirst();
        this.logger.log(Level.FINEST, new Object[]{"Found spurious counterexample,", "trying strategy 1: remove everything below", root, "from ART."});
        pReached.removeSubtree(root, (Precision)refinementResult.getSecond());
        this.artUpdate.stop();
    }

    @Override
    protected final List<Pair<ARTElement, CFANode>> transformPath(Path errorPath) {
        this.path = errorPath;
        this.refinePredicatePrecision = this.determineRefinementStrategy();
        ArrayList result = Lists.newArrayList();
        for (ARTElement ae : Iterables.skip((Iterable)Lists.transform((List)errorPath, (Function)Pair.getProjectionToFirst()), (int)1)) {
            if (this.refinePredicatePrecision) {
                PredicateAbstractElement pe = AbstractElements.extractElementByType(ae, PredicateAbstractElement.class);
                if (!pe.isAbstractionElement()) continue;
                CFANode location = AbstractElements.extractLocation(ae);
                result.add(Pair.of((Object)ae, (Object)location));
                continue;
            }
            result.add(Pair.of((Object)ae, (Object)AbstractElements.extractLocation(ae)));
        }
        assert (((Pair)errorPath.getLast()).getFirst() == ((Pair)result.get(result.size() - 1)).getFirst());
        return result;
    }

    @Override
    protected List<Formula> getFormulasForPath(List<Pair<ARTElement, CFANode>> errorPath, ARTElement initialElement) throws CPATransferException {
        if (this.refinePredicatePrecision) {
            List formulas = Lists.transform(errorPath, (Function)Functions.compose(GET_BLOCK_FORMULA, (Function)Functions.compose(AbstractElements.extractElementByTypeFunction(PredicateAbstractElement.class), (Function)Pair.getProjectionToFirst())));
            return formulas;
        }
        PathFormula currentPathFormula = this.pathFormulaManager.makeEmptyPathFormula();
        ArrayList<Formula> formulas = new ArrayList<Formula>(this.path.size());
        int i = 0;
        for (Pair<ARTElement, CFAEdge> pathElement : this.path) {
            if (++i == 1) continue;
            currentPathFormula = this.pathFormulaManager.makeAnd(currentPathFormula, (CFAEdge)pathElement.getSecond());
            formulas.add(currentPathFormula.getFormula());
            currentPathFormula = this.pathFormulaManager.makeEmptyPathFormula(currentPathFormula);
        }
        return formulas;
    }

    private Pair<ARTElement, Precision> performRefinement(Precision oldPrecision, List<Pair<ARTElement, CFANode>> errorPath, CounterexampleTraceInfo<Collection<AbstractionPredicate>> pInfo) throws CPAException {
        PredicateMap predicates = new PredicateMap(pInfo.getPredicatesForRefinement(), errorPath);
        ImmutableMultimap<CFANode, String> variableMapping = predicates.getVariableMapping(this.fmgr);
        Precision precision = null;
        if (this.refinePredicatePrecision) {
            precision = this.createPredicatePrecision(this.extractPredicatePrecision(oldPrecision), predicates);
            this.firstInterpolationPoint = predicates.firstInterpolationPoint;
        } else {
            this.allReferencedVariables.addAll(variableMapping.values());
            Multimap<CFANode, String> relevantVariablesOnPath = this.getRelevantVariablesOnPath(errorPath, predicates);
            assert (this.firstInterpolationPoint != null);
            precision = this.createExplicitPrecision(this.extractExplicitPrecision(oldPrecision), (Multimap<CFANode, String>)variableMapping, relevantVariablesOnPath);
        }
        return Pair.of((Object)this.firstInterpolationPoint.getFirst(), (Object)precision);
    }

    private ExplicitPrecision extractExplicitPrecision(Precision precision) {
        ExplicitPrecision explicitPrecision = Precisions.extractPrecisionByType(precision, ExplicitPrecision.class);
        if (explicitPrecision == null) {
            throw new IllegalStateException("Could not find the ExplicitPrecision for the error element");
        }
        return explicitPrecision;
    }

    private ExplicitPrecision createExplicitPrecision(ExplicitPrecision oldPrecision, Multimap<CFANode, String> variableMapping, Multimap<CFANode, String> relevantVariablesOnPath) {
        ExplicitPrecision explicitPrecision = new ExplicitPrecision(oldPrecision);
        HashMultimap additionalMapping = HashMultimap.create(variableMapping);
        additionalMapping.putAll(relevantVariablesOnPath);
        explicitPrecision.getCegarPrecision().addToMapping((SetMultimap<CFANode, String>)additionalMapping);
        return explicitPrecision;
    }

    private PredicatePrecision extractPredicatePrecision(Precision precision) {
        PredicatePrecision predicatePrecision = Precisions.extractPrecisionByType(precision, PredicatePrecision.class);
        if (predicatePrecision == null) {
            throw new IllegalStateException("Could not find the PredicatePrecision for the error element");
        }
        return predicatePrecision;
    }

    private PredicatePrecision createPredicatePrecision(PredicatePrecision oldPredicatePrecision, PredicateMap predicateMap) {
        SetMultimap<CFANode, AbstractionPredicate> oldPredicateMap = oldPredicatePrecision.getPredicateMap();
        Set<AbstractionPredicate> globalPredicates = oldPredicatePrecision.getGlobalPredicates();
        ImmutableSetMultimap.Builder pmapBuilder = ImmutableSetMultimap.builder();
        pmapBuilder.putAll(oldPredicateMap);
        for (Map.Entry predicateAtLocation : predicateMap.getPredicateMapping().entries()) {
            pmapBuilder.putAll(predicateAtLocation.getKey(), (Object[])new AbstractionPredicate[]{(AbstractionPredicate)predicateAtLocation.getValue()});
        }
        return new PredicatePrecision((ImmutableSetMultimap<CFANode, AbstractionPredicate>)pmapBuilder.build(), globalPredicates);
    }

    private boolean determineRefinementStrategy() {
        return this.predicateCpaAvailable && this.pathHashes.contains(this.getErrorPathAsString(this.path).hashCode());
    }

    private boolean hasMadeProgress() {
        Integer errorTraceHash = this.getErrorPathAsString(this.path).hashCode();
        if (this.predicateCpaAvailable && errorTraceHash.equals(this.previousPathHash)) {
            return false;
        }
        if (!this.predicateCpaAvailable && this.pathHashes.contains(errorTraceHash)) {
            return false;
        }
        this.previousPathHash = this.refinePredicatePrecision ? errorTraceHash : null;
        this.pathHashes.add(errorTraceHash);
        return true;
    }

    private Multimap<CFANode, String> getRelevantVariablesOnPath(List<Pair<ARTElement, CFANode>> errorPath, PredicateMap predicates) {
        CollectVariablesVisitor visitor = new CollectVariablesVisitor(this.allReferencedVariables);
        for (int i = errorPath.size() - 1; i >= 0; --i) {
            Pair<ARTElement, CFANode> element = errorPath.get(i);
            CFAEdge edge = ((CFANode)element.getSecond()).getEnteringEdge(0);
            if (!this.extractVariables(edge, visitor) && !predicates.isInterpolationPoint(edge.getSuccessor())) continue;
            this.firstInterpolationPoint = element;
        }
        return visitor.getVariablesAtLocations();
    }

    private boolean extractVariables(CFAEdge edge, CollectVariablesVisitor visitor) {
        boolean extracted = false;
        visitor.setCurrentScope(edge);
        switch (edge.getEdgeType()) {
            case StatementEdge: {
                IASTAssignment assignment;
                String assignedVariable;
                StatementEdge statementEdge = (StatementEdge)edge;
                if (!(statementEdge.getStatement() instanceof IASTAssignment) || !visitor.hasCollected(assignedVariable = (assignment = (IASTAssignment)((Object)statementEdge.getStatement())).getLeftHandSide().toASTString(), false)) break;
                ((IASTRightHandSide)assignment.getLeftHandSide()).accept(visitor);
                assignment.getRightHandSide().accept(visitor);
                extracted = true;
            }
        }
        return extracted;
    }

    private String getErrorPathAsString(List<Pair<ARTElement, CFAEdge>> errorPath) {
        StringBuilder sb = new StringBuilder();
        Function projectionToSecond = Pair.getProjectionToSecond();
        int index = 0;
        for (CFAEdge edge : Lists.transform(errorPath, (Function)projectionToSecond)) {
            sb.append(index + ": Line ");
            sb.append(edge.getLineNumber());
            sb.append(": ");
            sb.append(edge);
            sb.append("\n");
            ++index;
        }
        return sb.toString();
    }

    private class CollectVariablesVisitor
    extends DefaultExpressionVisitor<Void, RuntimeException>
    implements RightHandSideVisitor<Void, RuntimeException> {
        private CFAEdge edge = null;
        private final Set<String> collectedVariables = new HashSet<String>();
        private final Multimap<CFANode, String> variablesAtLocations = HashMultimap.create();

        public CollectVariablesVisitor(Collection<String> initialVariables) {
            this.collectedVariables.addAll(initialVariables);
        }

        private void collect(CFANode cfaNode, String variableName) {
            variableName = this.getScopedVariableName(cfaNode, variableName);
            this.collectedVariables.add(variableName);
            this.addVariableToLocation(variableName);
        }

        public boolean hasCollected(String variableName, boolean isAlreadyScoped) {
            if (!isAlreadyScoped) {
                variableName = this.getScopedVariableName(this.edge.getPredecessor(), variableName);
            }
            return this.collectedVariables.contains(variableName);
        }

        public ImmutableMultimap<CFANode, String> getVariablesAtLocations() {
            return new ImmutableMultimap.Builder().putAll(this.variablesAtLocations).build();
        }

        public void setCurrentScope(CFAEdge currentEdge) {
            this.edge = currentEdge;
        }

        private String getScopedVariableName(CFANode cfaNode, String variableName) {
            if (ExplicitRefiner.this.globalVars.contains(variableName)) {
                return variableName;
            }
            return cfaNode.getFunctionName() + "::" + variableName;
        }

        private void addVariableToLocation(String variable) {
            this.variablesAtLocations.put((Object)this.edge.getSuccessor(), (Object)variable);
        }

        @Override
        public Void visit(IASTIdExpression idExpression) {
            this.collect(this.edge.getPredecessor(), idExpression.getName());
            return null;
        }

        @Override
        public Void visit(IASTArraySubscriptExpression arraySubscriptExpression) {
            ((IASTRightHandSide)arraySubscriptExpression.getArrayExpression()).accept(this);
            ((IASTRightHandSide)arraySubscriptExpression.getSubscriptExpression()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTBinaryExpression binaryExpression) {
            ((IASTRightHandSide)binaryExpression.getOperand1()).accept(this);
            ((IASTRightHandSide)binaryExpression.getOperand2()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTCastExpression castExpression) {
            ((IASTRightHandSide)castExpression.getOperand()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTFieldReference fieldReference) {
            ((IASTRightHandSide)fieldReference.getFieldOwner()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTFunctionCallExpression functionCallExpression) {
            for (IASTExpression param : functionCallExpression.getParameterExpressions()) {
                ((IASTRightHandSide)param).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(IASTUnaryExpression unaryExpression) {
            ((IASTRightHandSide)unaryExpression.getOperand()).accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(IASTExpression expression) {
            return null;
        }
    }
}

