/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.logging.Handler;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;

public class ExplicitTest {
    @Test
    public void ignoreVariablesTest1() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.explicit.ExplicitCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.explicit.variableBlacklist", (Object)"main::__SELECTED_FEATURE_(\\w)*", (Object)"cpa.explicit.threshold", (Object)"200000");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        Files.writeFile((File)tmpFile, (Object)"ASSERT ! CHECK(ExplicitAnalysis, \"contains(__SELECTED_FEATURE_base)\") ;");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/explicit/explicitIgnoreFeatureVars.c");
        Assert.assertTrue((boolean)results.isSafe());
        tmpFile.deleteOnExit();
    }

    @Test
    public void ignoreVariablesTest2() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.explicit.ExplicitCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.explicit.variableBlacklist", (Object)"somethingElse", (Object)"cpa.explicit.threshold", (Object)"200000");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        Files.writeFile((File)tmpFile, (Object)"ASSERT ! CHECK(ExplicitAnalysis, \"contains(__SELECTED_FEATURE_base)\") ;");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/explicit/explicitIgnoreFeatureVars.c");
        Assert.assertTrue((boolean)results.isUnsafe());
        Assert.assertTrue((boolean)results.logContains("Automaton going to ErrorState on edge \"int __SELECTED_FEATURE_base;\""));
        tmpFile.deleteOnExit();
    }

    private TestResults run(Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        Configuration config = Configuration.builder().setOptions(pProperties).build();
        LogManager.StringHandler stringLogHandler = new LogManager.StringHandler();
        LogManager logger = new LogManager(config, (Handler)stringLogHandler);
        CPAchecker cpaChecker = new CPAchecker(config, logger);
        CPAcheckerResult results = cpaChecker.run(pSourceCodeFilePath);
        return new TestResults(stringLogHandler.getLog(), results);
    }

    private TestResults run(File configFile, Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        Configuration config = Configuration.builder().loadFromFile(configFile.getAbsolutePath()).setOptions(pProperties).build();
        LogManager.StringHandler stringLogHandler = new LogManager.StringHandler();
        LogManager logger = new LogManager(config, (Handler)stringLogHandler);
        CPAchecker cpaChecker = new CPAchecker(config, logger);
        CPAcheckerResult results = cpaChecker.run(pSourceCodeFilePath);
        return new TestResults(stringLogHandler.getLog(), results);
    }

    private static class TestResults {
        private String log;
        private CPAcheckerResult checkerResult;

        public TestResults(String pLog, CPAcheckerResult pCheckerResult) {
            this.log = pLog;
            this.checkerResult = pCheckerResult;
        }

        public String getLog() {
            return this.log;
        }

        public CPAcheckerResult getCheckerResult() {
            return this.checkerResult;
        }

        boolean logContains(String pattern) {
            return this.log.contains(pattern);
        }

        boolean isSafe() {
            return this.checkerResult.getResult().equals((Object)CPAcheckerResult.Result.SAFE);
        }

        boolean isUnsafe() {
            return this.checkerResult.getResult().equals((Object)CPAcheckerResult.Result.UNSAFE);
        }

        public String toString() {
            return this.log;
        }
    }
}

