/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.NumericTypes;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.MultiEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitPrecision;
import org.sosy_lab.cpachecker.cpa.pointer.Memory;
import org.sosy_lab.cpachecker.cpa.pointer.Pointer;
import org.sosy_lab.cpachecker.cpa.pointer.PointerElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

@Options(prefix="cpa.explicit")
public class ExplicitTransferRelation
implements TransferRelation {
    private final Set<String> globalVariables = new HashSet<String>();
    static Set<String> globalVarsStatic = null;
    private String missingInformationLeftVariable = null;
    private String missingInformationLeftPointer = null;
    private IASTRightHandSide missingInformationRightExpression = null;
    private ExplicitPrecision currentPrecision = null;

    public ExplicitTransferRelation(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        globalVarsStatic = this.globalVariables;
    }

    public Collection<ExplicitElement> getAbstractSuccessors(AbstractElement element, Precision pPrecision, CFAEdge cfaEdge) throws CPATransferException {
        ExplicitElement successor;
        ExplicitPrecision explicitPrecision;
        ExplicitElement explicitElement = (ExplicitElement)element;
        this.currentPrecision = explicitPrecision = (ExplicitPrecision)pPrecision;
        explicitPrecision.setLocation(cfaEdge.getSuccessor());
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                successor = this.handleAssumption(explicitElement.clone(), assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption(), explicitPrecision);
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(explicitElement, functionCallEdge);
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)cfaEdge;
                successor = this.handleFunctionReturn(explicitElement, functionReturnEdge);
                break;
            }
            default: {
                successor = explicitElement.clone();
                this.handleSimpleEdge(successor, explicitPrecision, cfaEdge);
            }
        }
        if (successor == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(successor);
    }

    private void handleSimpleEdge(ExplicitElement element, ExplicitPrecision precision, CFAEdge cfaEdge) throws CPATransferException {
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)cfaEdge;
                this.handleStatement(element, statementEdge.getStatement(), cfaEdge, precision);
                break;
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge returnEdge = (ReturnStatementEdge)cfaEdge;
                this.handleExitFromFunction(element, returnEdge.getExpression(), returnEdge);
                break;
            }
            case DeclarationEdge: {
                DeclarationEdge declarationEdge = (DeclarationEdge)cfaEdge;
                this.handleDeclaration(element, declarationEdge, precision);
                break;
            }
            case BlankEdge: {
                break;
            }
            case MultiEdge: {
                for (CFAEdge edge : (MultiEdge)cfaEdge) {
                    this.handleSimpleEdge(element, precision, edge);
                }
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
    }

    private ExplicitElement handleFunctionCall(ExplicitElement element, FunctionCallEdge callEdge) throws UnrecognizedCCodeException {
        ExplicitElement newElement = new ExplicitElement(element);
        for (String globalVar : this.globalVariables) {
            if (!element.contains(globalVar)) continue;
            newElement.assignConstant(globalVar, element.getValueFor(globalVar));
        }
        FunctionDefinitionNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<IASTExpression> arguments = callEdge.getArguments();
        if (!callEdge.getSuccessor().getFunctionDefinition().getDeclSpecifier().takesVarArgs()) assert (paramNames.size() == arguments.size());
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(callEdge, element, callerFunctionName);
        for (int i = 0; i < paramNames.size(); ++i) {
            Long value = ((IASTRightHandSide)arguments.get(i)).accept(visitor);
            String formalParamName = this.getScopedVariableName(paramNames.get(i), calledFunctionName);
            if (value == null) {
                newElement.forget(formalParamName);
                continue;
            }
            newElement.assignConstant(formalParamName, value);
        }
        return newElement;
    }

    private void handleExitFromFunction(ExplicitElement newElement, IASTExpression expression, ReturnStatementEdge returnEdge) throws UnrecognizedCCodeException {
        if (expression == null) {
            expression = NumericTypes.ZERO;
        }
        String functionName = returnEdge.getPredecessor().getFunctionName();
        this.handleAssignmentToVariable("___cpa_temp_result_var_", expression, new ExpressionValueVisitor(returnEdge, newElement, functionName));
    }

    private ExplicitElement handleFunctionReturn(ExplicitElement element, FunctionReturnEdge functionReturnEdge) throws UnrecognizedCCodeException {
        CallToReturnEdge summaryEdge = functionReturnEdge.getSuccessor().getEnteringSummaryEdge();
        IASTFunctionCall exprOnSummary = summaryEdge.getExpression();
        ExplicitElement newElement = element.getPreviousElement().clone();
        String callerFunctionName = functionReturnEdge.getSuccessor().getFunctionName();
        String calledFunctionName = functionReturnEdge.getPredecessor().getFunctionName();
        for (String variableName : this.globalVariables) {
            if (element.contains(variableName)) {
                newElement.assignConstant(variableName, element.getValueFor(variableName));
                continue;
            }
            newElement.forget(variableName);
        }
        if (exprOnSummary instanceof IASTFunctionCallAssignmentStatement) {
            IASTFunctionCallAssignmentStatement assignExp = (IASTFunctionCallAssignmentStatement)exprOnSummary;
            IASTExpression op1 = assignExp.getLeftHandSide();
            if (op1 instanceof IASTIdExpression || op1 instanceof IASTFieldReference) {
                String returnVarName = this.getScopedVariableName("___cpa_temp_result_var_", calledFunctionName);
                String assignedVarName = this.getScopedVariableName(op1.toASTString(), callerFunctionName);
                if (element.contains(returnVarName)) {
                    newElement.assignConstant(assignedVarName, element.getValueFor(returnVarName));
                } else {
                    newElement.forget(assignedVarName);
                }
            } else {
                if (op1 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op1).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                    return newElement;
                }
                throw new UnrecognizedCCodeException("on function return", summaryEdge, op1);
            }
        }
        return newElement;
    }

    private ExplicitElement handleAssumption(ExplicitElement element, IASTExpression expression, CFAEdge cfaEdge, boolean truthValue, ExplicitPrecision precision) throws UnrecognizedCCodeException {
        String functionName;
        Long value = this.getExpressionValue(element, expression = this.optimizeAssumeForEvaluation(expression), functionName = cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
        if (value == null) {
            AssigningValueVisitor avv = new AssigningValueVisitor(cfaEdge, element, functionName, truthValue);
            ((IASTRightHandSide)expression).accept(avv);
            return element;
        }
        if (truthValue && value == 1L || !truthValue && value == 0L) {
            return element;
        }
        return null;
    }

    private void handleDeclaration(ExplicitElement newElement, DeclarationEdge declarationEdge, ExplicitPrecision precision) throws UnrecognizedCCodeException {
        IASTInitializer init;
        if (!(declarationEdge.getDeclaration() instanceof IASTVariableDeclaration)) {
            return;
        }
        IASTVariableDeclaration decl = (IASTVariableDeclaration)declarationEdge.getDeclaration();
        String varName = decl.getName();
        String functionName = declarationEdge.getPredecessor().getFunctionName();
        Long initialValue = null;
        if (decl.isGlobal()) {
            this.globalVariables.add(varName);
            initialValue = 0L;
        }
        if ((init = decl.getInitializer()) instanceof IASTInitializerExpression) {
            IASTExpression exp = ((IASTInitializerExpression)init).getExpression();
            initialValue = this.getExpressionValue(newElement, exp, functionName, declarationEdge);
        }
        String scopedVarName = this.getScopedVariableName(varName, functionName);
        if (initialValue != null && precision.isTracking(scopedVarName)) {
            newElement.assignConstant(scopedVarName, initialValue);
        } else {
            newElement.forget(scopedVarName);
        }
    }

    private void handleStatement(ExplicitElement newElement, IASTStatement expression, CFAEdge cfaEdge, ExplicitPrecision precision) throws UnrecognizedCCodeException {
        if (expression instanceof IASTAssignment) {
            this.handleAssignment(newElement, (IASTAssignment)((Object)expression), cfaEdge, precision);
        } else if (!(expression instanceof IASTFunctionCallStatement) && !(expression instanceof IASTExpressionStatement)) {
            throw new UnrecognizedCCodeException(cfaEdge, expression);
        }
    }

    private void handleAssignment(ExplicitElement newElement, IASTAssignment assignExpression, CFAEdge cfaEdge, ExplicitPrecision precision) throws UnrecognizedCCodeException {
        IASTExpression op1 = assignExpression.getLeftHandSide();
        IASTRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof IASTIdExpression) {
            if (!precision.isOnBlacklist(this.getScopedVariableName(((IASTIdExpression)op1).getName(), cfaEdge.getPredecessor().getFunctionName()))) {
                String functionName = cfaEdge.getPredecessor().getFunctionName();
                this.handleAssignmentToVariable(op1.toASTString(), op2, new ExpressionValueVisitor(cfaEdge, newElement, functionName));
            }
        } else {
            if (op1 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op1).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                if ((op1 = ((IASTUnaryExpression)op1).getOperand()) instanceof IASTCastExpression) {
                    op1 = ((IASTCastExpression)op1).getOperand();
                }
                if (op1 instanceof IASTIdExpression) {
                    this.missingInformationLeftPointer = ((IASTIdExpression)op1).getName();
                    this.missingInformationRightExpression = op2;
                }
                return;
            }
            if (op1 instanceof IASTFieldReference) {
                if (precision.isOnBlacklist(this.getScopedVariableName(op1.toASTString(), cfaEdge.getPredecessor().getFunctionName()))) {
                    return;
                }
                String functionName = cfaEdge.getPredecessor().getFunctionName();
                this.handleAssignmentToVariable(op1.toASTString(), op2, new ExpressionValueVisitor(cfaEdge, newElement, functionName));
            } else if (!(op1 instanceof IASTArraySubscriptExpression)) {
                throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
            }
        }
    }

    private void handleAssignmentToVariable(String lParam, IASTRightHandSide exp, ExpressionValueVisitor visitor) throws UnrecognizedCCodeException {
        Long value = exp.accept(visitor);
        if (visitor.missingPointer) {
            this.missingInformationRightExpression = exp;
            assert (value == null);
        }
        ExplicitElement newElement = visitor.element;
        String assignedVar = this.getScopedVariableName(lParam, visitor.functionName);
        if (value == null) {
            newElement.forget(assignedVar);
        } else if (this.currentPrecision.isTracking(assignedVar) || assignedVar.endsWith("___cpa_temp_result_var_")) {
            newElement.assignConstant(assignedVar, value);
        } else {
            newElement.forget(assignedVar);
        }
    }

    private Long getExpressionValue(ExplicitElement element, IASTRightHandSide expression, String functionName, CFAEdge edge) throws UnrecognizedCCodeException {
        return expression.accept(new ExpressionValueVisitor(edge, element, functionName));
    }

    public String getScopedVariableName(String variableName, String functionName) {
        if (this.globalVariables.contains(variableName)) {
            return variableName;
        }
        return functionName + "::" + variableName;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> elements, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        assert (element instanceof ExplicitElement);
        ExplicitElement explicitElement = (ExplicitElement)element;
        for (AbstractElement ae : elements) {
            if (!(ae instanceof PointerElement)) continue;
            return this.strengthen(explicitElement, (PointerElement)ae, cfaEdge, precision);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends AbstractElement> strengthen(ExplicitElement explicitElement, PointerElement pointerElement, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        try {
            if (this.missingInformationRightExpression != null) {
                String leftVar;
                String functionName = cfaEdge.getPredecessor().getFunctionName();
                ExplicitElement newElement = explicitElement.clone();
                PointerExpressionValueVisitor v = new PointerExpressionValueVisitor(cfaEdge, newElement, functionName, pointerElement);
                if (this.missingInformationLeftVariable != null) {
                    this.handleAssignmentToVariable(this.missingInformationLeftVariable, this.missingInformationRightExpression, v);
                    Set<ExplicitElement> set = Collections.singleton(newElement);
                    return set;
                }
                if (this.missingInformationLeftPointer != null && (leftVar = this.derefPointerToVariable(pointerElement, this.missingInformationLeftPointer)) != null) {
                    leftVar = this.getScopedVariableName(leftVar, functionName);
                    this.handleAssignmentToVariable(leftVar, this.missingInformationRightExpression, v);
                    Set<ExplicitElement> set = Collections.singleton(newElement);
                    return set;
                }
            }
            Collection<? extends AbstractElement> collection = null;
            return collection;
        }
        finally {
            this.missingInformationLeftVariable = null;
            this.missingInformationLeftPointer = null;
            this.missingInformationRightExpression = null;
        }
    }

    private String derefPointerToVariable(PointerElement pointerElement, String pointer) {
        Pointer p = pointerElement.lookupPointer(pointer);
        if (p != null && p.getNumberOfTargets() == 1) {
            Memory.PointerTarget target = p.getFirstTarget();
            if (target instanceof Memory.Variable) {
                return ((Memory.Variable)target).getVarName();
            }
            if (target instanceof Memory.StackArrayCell) {
                return ((Memory.StackArrayCell)target).getVarName();
            }
        }
        return null;
    }

    private IASTExpression optimizeAssumeForEvaluation(IASTExpression expression) {
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
            IASTBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
            IASTExpression leftOperand = binaryExpression.getOperand1();
            IASTExpression riteOperand = binaryExpression.getOperand2();
            if ((operator == IASTBinaryExpression.BinaryOperator.EQUALS || operator == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) && leftOperand instanceof IASTBinaryExpression && riteOperand instanceof IASTLiteralExpression) {
                IASTBinaryExpression expr = (IASTBinaryExpression)leftOperand;
                IASTBinaryExpression.BinaryOperator operation = expr.getOperator();
                IASTExpression leftAddend = expr.getOperand1();
                IASTExpression riteAddend = expr.getOperand2();
                if (riteAddend instanceof IASTLiteralExpression && (operation == IASTBinaryExpression.BinaryOperator.PLUS || operation == IASTBinaryExpression.BinaryOperator.MINUS)) {
                    IASTBinaryExpression.BinaryOperator newOperation = operation == IASTBinaryExpression.BinaryOperator.PLUS ? IASTBinaryExpression.BinaryOperator.MINUS : IASTBinaryExpression.BinaryOperator.PLUS;
                    IASTBinaryExpression sum = new IASTBinaryExpression(expr.getFileLocation(), expr.getExpressionType(), riteOperand, riteAddend, newOperation);
                    IASTBinaryExpression assume = new IASTBinaryExpression(expression.getFileLocation(), expression.getExpressionType(), leftAddend, sum, operator);
                    return assume;
                }
            }
        }
        return expression;
    }

    private class PointerExpressionValueVisitor
    extends ExpressionValueVisitor {
        private final PointerElement pointerElement;

        public PointerExpressionValueVisitor(CFAEdge pEdge, ExplicitElement pElement, String pFunctionName, PointerElement pPointerElement) {
            super(pEdge, pElement, pFunctionName);
            this.pointerElement = pPointerElement;
        }

        @Override
        public Long visit(IASTUnaryExpression unaryExpression) throws UnrecognizedCCodeException {
            if (unaryExpression.getOperator() != IASTUnaryExpression.UnaryOperator.STAR) {
                return super.visit(unaryExpression);
            }
            IASTExpression unaryOperand = unaryExpression.getOperand();
            if (unaryOperand instanceof IASTCastExpression) {
                unaryOperand = ((IASTCastExpression)unaryOperand).getOperand();
            }
            if (unaryOperand instanceof IASTIdExpression) {
                String rightVar = ExplicitTransferRelation.this.derefPointerToVariable(this.pointerElement, ((IASTIdExpression)unaryOperand).getName());
                if (rightVar != null && this.element.contains(rightVar = ExplicitTransferRelation.this.getScopedVariableName(rightVar, this.functionName))) {
                    return this.element.getValueFor(rightVar);
                }
            } else {
                throw new UnrecognizedCCodeException("Pointer dereference of something that is not a variable", this.edge, unaryExpression);
            }
            return null;
        }
    }

    private class AssigningValueVisitor
    extends ExpressionValueVisitor {
        protected boolean truthValue;

        public AssigningValueVisitor(CFAEdge pEdge, ExplicitElement pElement, String pFunctionName, boolean truthValue) {
            super(pEdge, pElement, pFunctionName);
            this.truthValue = false;
            this.truthValue = truthValue;
        }

        private IASTExpression unwrap(IASTExpression expression) {
            IASTExpression exp;
            if (expression instanceof IASTUnaryExpression && ((IASTUnaryExpression)(exp = (IASTUnaryExpression)expression)).getOperator() == IASTUnaryExpression.UnaryOperator.NOT) {
                expression = ((IASTUnaryExpression)exp).getOperand();
                this.truthValue = !this.truthValue;
                expression = this.unwrap(expression);
            }
            if (expression instanceof IASTCastExpression) {
                exp = (IASTCastExpression)expression;
                expression = ((IASTCastExpression)exp).getOperand();
                expression = this.unwrap(expression);
            }
            return expression;
        }

        @Override
        public Long visit(IASTBinaryExpression pE) throws UnrecognizedCCodeException {
            IASTBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
            IASTExpression lVarInBinaryExp = pE.getOperand1();
            lVarInBinaryExp = this.unwrap(lVarInBinaryExp);
            IASTExpression rVarInBinaryExp = pE.getOperand2();
            Long leftValue = ((IASTRightHandSide)lVarInBinaryExp).accept(this);
            Long rightValue = ((IASTRightHandSide)rVarInBinaryExp).accept(this);
            if (binaryOperator == IASTBinaryExpression.BinaryOperator.EQUALS && this.truthValue || binaryOperator == IASTBinaryExpression.BinaryOperator.NOT_EQUALS && !this.truthValue) {
                if (leftValue == null && rightValue != null && this.isAssignable(lVarInBinaryExp)) {
                    String leftVariableName = ExplicitTransferRelation.this.getScopedVariableName(lVarInBinaryExp.toASTString(), this.functionName);
                    if (ExplicitTransferRelation.this.currentPrecision.isTracking(leftVariableName)) {
                        this.element.assignConstant(leftVariableName, rightValue);
                    }
                } else if (rightValue == null && leftValue != null && this.isAssignable(rVarInBinaryExp)) {
                    String rightVariableName = ExplicitTransferRelation.this.getScopedVariableName(rVarInBinaryExp.toASTString(), this.functionName);
                    if (ExplicitTransferRelation.this.currentPrecision.isTracking(rightVariableName)) {
                        this.element.assignConstant(rightVariableName, leftValue);
                    }
                }
            }
            return super.visit(pE);
        }

        private boolean isAssignable(IASTExpression expression) {
            return expression instanceof IASTIdExpression || expression instanceof IASTFieldReference;
        }
    }

    private class ExpressionValueVisitor
    extends DefaultExpressionVisitor<Long, UnrecognizedCCodeException>
    implements RightHandSideVisitor<Long, UnrecognizedCCodeException> {
        protected final CFAEdge edge;
        protected final ExplicitElement element;
        protected final String functionName;
        private boolean missingPointer = false;

        public ExpressionValueVisitor(CFAEdge pEdge, ExplicitElement pElement, String pFunctionName) {
            this.edge = pEdge;
            this.element = pElement;
            this.functionName = pFunctionName;
        }

        @Override
        protected Long visitDefault(IASTExpression pExp) {
            return null;
        }

        @Override
        public Long visit(IASTBinaryExpression pE) throws UnrecognizedCCodeException {
            IASTBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
            IASTExpression lVarInBinaryExp = pE.getOperand1();
            IASTExpression rVarInBinaryExp = pE.getOperand2();
            switch (binaryOperator) {
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case MULTIPLY: 
                case SHIFT_LEFT: 
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    Long lVal = ((IASTRightHandSide)lVarInBinaryExp).accept(this);
                    if (lVal == null) {
                        return null;
                    }
                    Long rVal = ((IASTRightHandSide)rVarInBinaryExp).accept(this);
                    if (rVal == null) {
                        return null;
                    }
                    switch (binaryOperator) {
                        case PLUS: {
                            return lVal + rVal;
                        }
                        case MINUS: {
                            return lVal - rVal;
                        }
                        case DIVIDE: {
                            if (rVal == 0L) {
                                return null;
                            }
                            return lVal / rVal;
                        }
                        case MULTIPLY: {
                            return lVal * rVal;
                        }
                        case SHIFT_LEFT: {
                            return lVal << (int)rVal.longValue();
                        }
                        case BINARY_AND: {
                            return lVal & rVal;
                        }
                        case BINARY_OR: {
                            return lVal | rVal;
                        }
                        case BINARY_XOR: {
                            return lVal ^ rVal;
                        }
                    }
                    throw new AssertionError();
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    boolean result;
                    Long lVal = ((IASTRightHandSide)lVarInBinaryExp).accept(this);
                    if (lVal == null) {
                        return null;
                    }
                    Long rVal = ((IASTRightHandSide)rVarInBinaryExp).accept(this);
                    if (rVal == null) {
                        return null;
                    }
                    long l = lVal;
                    long r = rVal;
                    switch (binaryOperator) {
                        case EQUALS: {
                            result = l == r;
                            break;
                        }
                        case NOT_EQUALS: {
                            result = l != r;
                            break;
                        }
                        case GREATER_THAN: {
                            result = l > r;
                            break;
                        }
                        case GREATER_EQUAL: {
                            result = l >= r;
                            break;
                        }
                        case LESS_THAN: {
                            result = l < r;
                            break;
                        }
                        case LESS_EQUAL: {
                            result = l <= r;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    return result ? 1L : 0L;
                }
            }
            return null;
        }

        @Override
        public Long visit(IASTCastExpression pE) throws UnrecognizedCCodeException {
            return ((IASTRightHandSide)pE.getOperand()).accept(this);
        }

        @Override
        public Long visit(IASTFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public Long visit(IASTCharLiteralExpression pE) throws UnrecognizedCCodeException {
            return pE.getCharacter();
        }

        @Override
        public Long visit(IASTFloatLiteralExpression pE) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public Long visit(IASTIntegerLiteralExpression pE) throws UnrecognizedCCodeException {
            return pE.asLong();
        }

        @Override
        public Long visit(IASTStringLiteralExpression pE) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public Long visit(IASTIdExpression idExp) throws UnrecognizedCCodeException {
            if (idExp.getDeclaration() instanceof IASTEnumerationSpecifier.IASTEnumerator) {
                IASTEnumerationSpecifier.IASTEnumerator enumerator = (IASTEnumerationSpecifier.IASTEnumerator)idExp.getDeclaration();
                if (enumerator.hasValue()) {
                    return enumerator.getValue();
                }
                return null;
            }
            String varName = ExplicitTransferRelation.this.getScopedVariableName(idExp.getName(), this.functionName);
            if (this.element.contains(varName)) {
                return this.element.getValueFor(varName);
            }
            return null;
        }

        @Override
        public Long visit(IASTUnaryExpression unaryExpression) throws UnrecognizedCCodeException {
            IASTUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            IASTExpression unaryOperand = unaryExpression.getOperand();
            Long value = null;
            switch (unaryOperator) {
                case MINUS: {
                    value = ((IASTRightHandSide)unaryOperand).accept(this);
                    return value != null ? Long.valueOf(-value.longValue()) : null;
                }
                case NOT: {
                    value = ((IASTRightHandSide)unaryOperand).accept(this);
                    if (value == null) {
                        return null;
                    }
                    return value == 0L ? 1L : 0L;
                }
                case AMPER: {
                    return null;
                }
                case STAR: {
                    this.missingPointer = true;
                    return null;
                }
            }
            return null;
        }

        @Override
        public Long visit(IASTFieldReference fieldReferenceExpression) throws UnrecognizedCCodeException {
            String varName = ExplicitTransferRelation.this.getScopedVariableName(fieldReferenceExpression.toASTString(), this.functionName);
            if (this.element.contains(varName)) {
                return this.element.getValueFor(varName);
            }
            return null;
        }
    }
}

