/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitPrecision;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractElements;

public class OmniscientCompositePrecisionAdjustment
extends CompositePrecisionAdjustment
implements StatisticsProvider {
    final Timer totalEnforcePathThreshold = new Timer();
    final Timer totalEnforceReachedSetThreshold = new Timer();
    final Timer totalComposite = new Timer();
    final Timer total = new Timer();
    private Statistics stats = new Statistics(){

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            pOut.println("total time:                 " + OmniscientCompositePrecisionAdjustment.this.total.getSumTime());
            pOut.println("total time for composite:   " + OmniscientCompositePrecisionAdjustment.this.totalComposite.getSumTime());
            pOut.println("total time for reached set: " + OmniscientCompositePrecisionAdjustment.this.totalEnforceReachedSetThreshold.getSumTime());
            pOut.println("total time for path:        " + OmniscientCompositePrecisionAdjustment.this.totalEnforcePathThreshold.getSumTime());
        }

        @Override
        public String getName() {
            return "OmniscientCompositePrecisionAdjustment Stats";
        }
    };
    private boolean modified = false;

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    public OmniscientCompositePrecisionAdjustment(ImmutableList<PrecisionAdjustment> precisionAdjustments) {
        super(precisionAdjustments);
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision pPrecision, UnmodifiableReachedSet pElements) throws CPAException {
        this.total.start();
        this.modified = false;
        CompositeElement composite = (CompositeElement)pElement;
        CompositePrecision precision = (CompositePrecision)pPrecision;
        assert (composite.getWrappedElements().size() == precision.getPrecisions().size());
        int indexOfExplicitState = this.getIndexOfExplicitState(composite);
        if (indexOfExplicitState == -1) {
            throw new CPAException("The OmniscientCompositePrecisionAdjustment needs an ExplicitElement");
        }
        ImmutableList.Builder outElements = ImmutableList.builder();
        ImmutableList.Builder outPrecisions = ImmutableList.builder();
        PrecisionAdjustment.Action action = PrecisionAdjustment.Action.CONTINUE;
        int size = composite.getWrappedElements().size();
        for (int i = 0; i < size; ++i) {
            UnmodifiableReachedSetView slice = new UnmodifiableReachedSetView(pElements, (Function<? super AbstractElement, AbstractElement>)((Function)this.elementProjectionFunctions.get(i)), (Function<? super Precision, Precision>)((Function)this.precisionProjectionFunctions.get(i)));
            PrecisionAdjustment precisionAdjustment = (PrecisionAdjustment)this.precisionAdjustments.get(i);
            AbstractElement oldElement = composite.get(i);
            Precision oldPrecision = precision.get(i);
            if (i == indexOfExplicitState) {
                ExplicitElement explicit = (ExplicitElement)oldElement;
                ExplicitPrecision explicitPrecision = (ExplicitPrecision)oldPrecision;
                LocationElement location = AbstractElements.extractElementByType(composite, LocationElement.class);
                AssignmentsInPathCondition.AssignmentsInPathConditionElement assigns = AbstractElements.extractElementByType(composite, AssignmentsInPathCondition.AssignmentsInPathConditionElement.class);
                this.totalEnforceReachedSetThreshold.start();
                ExplicitElement newElement = this.enforceReachedSetThreshold(explicit, explicitPrecision, slice.getReached(location.getLocationNode()));
                this.totalEnforceReachedSetThreshold.stop();
                this.totalEnforcePathThreshold.start();
                Pair<ExplicitElement, ExplicitPrecision> result = this.enforcePathThreshold(newElement, explicitPrecision, assigns);
                this.totalEnforcePathThreshold.stop();
                outElements.add(result.getFirst());
                outPrecisions.add(result.getSecond());
                continue;
            }
            this.totalComposite.start();
            Triple<AbstractElement, Precision, PrecisionAdjustment.Action> result = precisionAdjustment.prec(oldElement, oldPrecision, slice);
            AbstractElement newElement = (AbstractElement)result.getFirst();
            Precision newPrecision = (Precision)result.getSecond();
            if (result.getThird() == PrecisionAdjustment.Action.BREAK) {
                action = PrecisionAdjustment.Action.BREAK;
            }
            if (newElement != oldElement || newPrecision != oldPrecision) {
                this.modified = true;
            }
            outElements.add((Object)newElement);
            outPrecisions.add((Object)newPrecision);
            this.totalComposite.stop();
        }
        AbstractElement outElement = this.modified ? new CompositeElement((List<AbstractElement>)outElements.build()) : pElement;
        Precision outPrecision = this.modified ? new CompositePrecision((List<Precision>)outPrecisions.build()) : pPrecision;
        this.total.stop();
        return new Triple((Object)outElement, (Object)outPrecision, (Object)action);
    }

    private ExplicitElement enforceReachedSetThreshold(ExplicitElement element, ExplicitPrecision precision, Collection<AbstractElement> reachedSetAtLocation) {
        HashMultimap<String, Long> valueMapping = this.createMappingFromReachedSet(reachedSetAtLocation);
        for (String variable : valueMapping.keySet()) {
            if (!precision.getReachedSetThresholds().exceeds(variable, valueMapping.get((Object)variable).size())) continue;
            precision.getReachedSetThresholds().setExceeded(variable);
            element.forget(variable);
        }
        return element;
    }

    private Pair<ExplicitElement, ExplicitPrecision> enforcePathThreshold(ExplicitElement element, ExplicitPrecision precision, AssignmentsInPathCondition.AssignmentsInPathConditionElement assigns) {
        if (assigns != null) {
            if (assigns instanceof AssignmentsInPathCondition.UniqueAssignmentsInPathConditionElement) {
                AssignmentsInPathCondition.UniqueAssignmentsInPathConditionElement unique = (AssignmentsInPathCondition.UniqueAssignmentsInPathConditionElement)assigns;
                unique.addAssignment(element);
            }
            for (Map.Entry<String, Integer> entry : assigns.getAssignmentCounts().entrySet()) {
                if (!precision.getPathThresholds().exceeds(entry.getKey(), entry.getValue())) continue;
                if (!this.modified) {
                    precision = new ExplicitPrecision(precision);
                    this.modified = true;
                }
                precision.getReachedSetThresholds().setExceeded(entry.getKey());
                element.forget(entry.getKey());
            }
        }
        return Pair.of((Object)element, (Object)precision);
    }

    private int getIndexOfExplicitState(CompositeElement composite) {
        for (int i = 0; i < composite.getWrappedElements().size(); ++i) {
            if (!(composite.get(i) instanceof ExplicitElement)) continue;
            return i;
        }
        return -1;
    }

    private HashMultimap<String, Long> createMappingFromReachedSet(Collection<AbstractElement> reachedSetAtLocation) {
        HashMultimap valueMapping = HashMultimap.create();
        for (AbstractElement element : reachedSetAtLocation) {
            for (Map.Entry<String, Long> entry : ((ExplicitElement)element).getConstantsMap().entrySet()) {
                valueMapping.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return valueMapping;
    }
}

