/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.explicit;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class PredicateMap {
    private ImmutableSetMultimap<CFANode, AbstractionPredicate> predicateMap;
    public Pair<ARTElement, CFANode> firstInterpolationPoint = null;

    public PredicateMap(List<Collection<AbstractionPredicate>> pathPredicates, List<Pair<ARTElement, CFANode>> pPath) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        int i = 0;
        for (Collection<AbstractionPredicate> predicates : pathPredicates) {
            if (predicates.size() > 0) {
                CFANode currentLocation = (CFANode)pPath.get(i).getSecond();
                for (AbstractionPredicate predicate : predicates) {
                    builder.put((Object)currentLocation, (Object)predicate);
                }
                if (this.firstInterpolationPoint == null) {
                    this.firstInterpolationPoint = Pair.of((Object)pPath.get(i).getFirst(), (Object)pPath.get(i).getSecond());
                }
            }
            ++i;
        }
        this.predicateMap = builder.build();
    }

    public ImmutableMultimap<CFANode, AbstractionPredicate> getPredicateMapping() {
        return this.predicateMap;
    }

    public boolean isInterpolationPoint(CFANode location) {
        return this.predicateMap.containsKey((Object)location);
    }

    public ImmutableMultimap<CFANode, String> getVariableMapping(FormulaManager fmgr) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry predicateAtLocation : this.predicateMap.entries()) {
            CFANode currentLocation = (CFANode)predicateAtLocation.getKey();
            AbstractionPredicate currentPredicate = (AbstractionPredicate)predicateAtLocation.getValue();
            Set<String> atoms = fmgr.extractVariables(currentPredicate.getSymbolicAtom());
            if (atoms.isEmpty()) continue;
            builder.putAll((Object)currentLocation, atoms);
        }
        return builder.build();
    }

    public String toString() {
        return this.predicateMap.toString();
    }
}

