/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.featurevariables;

import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsDomain;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsElement;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsPrecision;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsTransferRelation;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDRegionManager;

@Options(prefix="cpa.featurevars")
public class FeatureVarsCPA
implements ConfigurableProgramAnalysis {
    @Option(name="variableWhitelist", description="whitelist regex for variables that will be tracked by FeatureVarsCPA")
    private String variableWhitelist = "";
    private final FeatureVarsElement initialElement;
    private final FeatureVarsPrecision initialPrecision;
    private final AbstractDomain abstractDomain;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final TransferRelation transferRelation;
    private final PrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(FeatureVarsCPA.class);
    }

    private FeatureVarsCPA(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        NamedRegionManager manager = new NamedRegionManager(BDDRegionManager.getInstance());
        this.initialElement = new FeatureVarsElement(manager.makeTrue(), manager);
        this.initialPrecision = new FeatureVarsPrecision(this.variableWhitelist);
        this.abstractDomain = new FeatureVarsDomain(manager);
        this.mergeOperator = new MergeJoinOperator(this.abstractDomain);
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = new FeatureVarsTransferRelation(manager);
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        return this.initialElement;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return this.initialPrecision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }
}

