/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.featurevariables;

import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsElement;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

public class FeatureVarsDomain
implements AbstractDomain {
    private final NamedRegionManager rmgr;

    public FeatureVarsDomain(NamedRegionManager manager) {
        this.rmgr = manager;
    }

    @Override
    public boolean isLessOrEqual(AbstractElement newElement, AbstractElement reachedElement) {
        if (newElement instanceof FeatureVarsElement && reachedElement instanceof FeatureVarsElement) {
            FeatureVarsElement fvn = (FeatureVarsElement)newElement;
            FeatureVarsElement fvr = (FeatureVarsElement)reachedElement;
            return this.rmgr.entails(fvn.getRegion(), fvr.getRegion());
        }
        throw new IllegalArgumentException("Called with non-FeatureVars-Elements");
    }

    @Override
    public AbstractElement join(AbstractElement element1, AbstractElement element2) {
        FeatureVarsElement fv1 = (FeatureVarsElement)element1;
        FeatureVarsElement fv2 = (FeatureVarsElement)element2;
        Region result = this.rmgr.makeOr(fv1.getRegion(), fv2.getRegion());
        if (result.equals(fv2.getRegion())) {
            return fv2;
        }
        if (result.equals(fv1.getRegion())) {
            return fv1;
        }
        return new FeatureVarsElement(result, this.rmgr);
    }
}

