/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.featurevariables;

import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

public class FeatureVarsElement
implements AbstractQueryableElement {
    private Region currentState;
    private final NamedRegionManager manager;

    public FeatureVarsElement(Region currentState, NamedRegionManager manager) {
        this.currentState = currentState;
        this.manager = manager;
    }

    public Region getRegion() {
        return this.currentState;
    }

    public NamedRegionManager getManager() {
        return this.manager;
    }

    public String toString() {
        return this.manager.dumpRegion(this.currentState);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        throw new InvalidQueryException("Feature Vars Element cannot check anything");
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equals("VALUES")) {
            return this.manager.dumpRegion(this.currentState);
        }
        throw new InvalidQueryException("Feature Vars Element can only return the current values (\"VALUES\")");
    }

    @Override
    public String getCPAName() {
        return "FeatureVars";
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("Feature Vars Element cannot be modified");
    }

    public void restrictWith(Region pErrorBDD) {
        this.currentState = this.manager.makeAnd(this.currentState, pErrorBDD);
    }
}

