/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.featurevariables;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;

public class FeatureVarsTest {
    @Test
    public void assignmentTest_True() throws Exception {
        Object prop = ImmutableMap.of((Object)"specification", (Object)"config/specification/FeatureVarsErrorLocation.spc", (Object)"cpa.explicit.threshold", (Object)"200", (Object)"cpa.explicit.variableBlacklist", (Object)"__SELECTED_FEATURE_(\\w)*", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        prop = new HashMap(prop);
        prop.put("cfa.removeIrrelevantForErrorLocations", "false");
        prop.put("analysis.traversal.order", "bfs");
        prop.put("analysis.traversal.useTopsort", "true");
        prop.put("analysis.traversal.useCallstack", "true");
        prop.put("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA, cpa.explicit.ExplicitCPA");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int main() {\n  __SELECTED_FEATURE_Verify = 1;  int tmp;\n    if (__SELECTED_FEATURE_Verify)\n              tmp = 1;\n    else tmp =  0;\n  if (! tmp) error: fail();\n  }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void assignmentTest_False() throws Exception {
        Object prop = ImmutableMap.of((Object)"specification", (Object)"config/specification/FeatureVarsErrorLocation.spc", (Object)"cpa.explicit.threshold", (Object)"200", (Object)"cpa.explicit.variableBlacklist", (Object)"__SELECTED_FEATURE_(\\w)*", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        prop = new HashMap(prop);
        prop.put("cfa.removeIrrelevantForErrorLocations", "false");
        prop.put("analysis.traversal.order", "bfs");
        prop.put("analysis.traversal.useTopsort", "true");
        prop.put("analysis.traversal.useCallstack", "true");
        prop.put("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA, cpa.explicit.ExplicitCPA");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int main() {\n  __SELECTED_FEATURE_Verify = 0;  int tmp;\n    if (!__SELECTED_FEATURE_Verify)\n              tmp = 0;\n    else tmp =  1;\n  if (tmp) error: fail();\n  }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void cooperationWithExplicit3VarsWithFunctionCall() throws Exception {
        Object prop = ImmutableMap.of((Object)"specification", (Object)"config/specification/FeatureVarsErrorLocation.spc", (Object)"cpa.explicit.threshold", (Object)"200", (Object)"cpa.explicit.variableBlacklist", (Object)"__SELECTED_FEATURE_(\\w)*", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        prop = new HashMap(prop);
        prop.put("cfa.removeIrrelevantForErrorLocations", "false");
        prop.put("analysis.traversal.order", "bfs");
        prop.put("analysis.traversal.useTopsort", "true");
        prop.put("analysis.traversal.useCallstack", "true");
        prop.put("cpa", "cpa.art.ARTCPA");
        prop.put("ARTCPA.cpa", "cpa.composite.CompositeCPA");
        prop.put("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA, cpa.explicit.ExplicitCPA");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/featureVarsTest.c");
        Assert.assertFalse((boolean)results.logLineMatches(".*Product violating in line (\\d)*: TRUE.*"));
        Assert.assertTrue((boolean)results.logContains("Product violating in line 16:"));
        Assert.assertTrue((boolean)results.logContains("!__SELECTED_FEATURE_Verify"));
        Assert.assertTrue((boolean)results.logContains("!__SELECTED_FEATURE_Sign"));
        Assert.assertTrue((boolean)results.logContains("__SELECTED_FEATURE_Forward"));
        Assert.assertTrue((boolean)results.isUnsafe());
    }

    @Test
    public void testStateReduction() throws Exception {
        Object prop = ImmutableMap.of((Object)"specification", (Object)"config/specification/FeatureVarsErrorLocation.spc", (Object)"cpa.explicit.threshold", (Object)"200", (Object)"cpa.explicit.variableBlacklist", (Object)"__SELECTED_FEATURE_(\\w)*", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        prop = new HashMap(prop);
        prop.put("cfa.removeIrrelevantForErrorLocations", "false");
        prop.put("cpa", "cpa.art.ARTCPA");
        prop.put("analysis.traversal.order", "bfs");
        prop.put("analysis.traversal.useTopsort", "true");
        prop.put("analysis.traversal.useCallstack", "true");
        prop.put("ARTCPA.cpa", "cpa.composite.CompositeCPA");
        prop.put("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA, cpa.explicit.ExplicitCPA");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int main() {\n  int tmp = 0;\n    if (! __SELECTED_FEATURE_Verify)\n        if (__SELECTED_FEATURE_Forward)\n            if (! __SELECTED_FEATURE_Sign)\n              tmp = 0;\n            else tmp =  1;\n        else tmp =  1;\n    else tmp =  1;\n  if (__SELECTED_FEATURE_Sign) error: fail();\n  }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.logLineMatches(".*Product violating in line (\\d)*: __SELECTED_FEATURE_Sign \\(Automaton.*"));
        Assert.assertTrue((boolean)results.isUnsafe());
    }

    @Test
    public void cooperationWithExplicit3VarsWithoutFunctionCall() throws Exception {
        Object prop = ImmutableMap.of((Object)"specification", (Object)"config/specification/FeatureVarsErrorLocation.spc", (Object)"cpa.explicit.threshold", (Object)"200", (Object)"cpa.explicit.variableBlacklist", (Object)"__SELECTED_FEATURE_(\\w)*", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        prop = new HashMap(prop);
        prop.put("cfa.removeIrrelevantForErrorLocations", "false");
        prop.put("cpa", "cpa.art.ARTCPA");
        prop.put("ARTCPA.cpa", "cpa.composite.CompositeCPA");
        prop.put("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA, cpa.explicit.ExplicitCPA");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int main() {\n  int tmp = 0;\n    if (! __SELECTED_FEATURE_Verify)\n        if (__SELECTED_FEATURE_Forward)\n            if (! __SELECTED_FEATURE_Sign)\n              tmp = 0;\n            else tmp =  1;\n        else tmp =  1;\n    else tmp =  1;\n  if (! tmp) error: fail();\n  }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        System.out.println(results.getLog());
        Assert.assertTrue((boolean)results.logContains("Valid Product: __SELECTED_FEATURE_Verify"));
        Assert.assertTrue((boolean)results.logContains("Product violating in line 10:"));
        Assert.assertTrue((boolean)results.logContains("!__SELECTED_FEATURE_Verify"));
        Assert.assertTrue((boolean)results.logContains("!__SELECTED_FEATURE_Sign"));
        Assert.assertTrue((boolean)results.logContains("__SELECTED_FEATURE_Forward"));
        Assert.assertTrue((boolean)results.isUnsafe());
    }

    @Test
    public void cooperationWithExplicit() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA, cpa.explicit.ExplicitCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.explicit.variableBlacklist", (Object)"__SELECTED_FEATURE_(\\w)*", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        tmpFile.deleteOnExit();
        Files.writeFile((File)tmpFile, (Object)"OBSERVER AUTOMATON tmpAutomaton\nINITIAL STATE Init;\nSTATE Init :\nMATCH {$1} ->\nPRINT \"Found $1 in Line $line\" GOTO Init;\nEND AUTOMATON");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int __SELECTED_FEATURE_base; int main() { if (__SELECTED_FEATURE_base && !__SELECTED_FEATURE_base ) { foo(1); } else {foo(2);} }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.logContains("Found foo(2);"));
        Assert.assertFalse((boolean)results.logContains("Found foo(1);"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void trackVariable() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        tmpFile.deleteOnExit();
        Files.writeFile((File)tmpFile, (Object)"OBSERVER AUTOMATON tmpAutomaton\nINITIAL STATE Init;\nSTATE Init :\nMATCH {$1} ->\nPRINT \"Found $1 in Line $line\" GOTO Init;\nEND AUTOMATON");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int __SELECTED_FEATURE_base; int main() { if (__SELECTED_FEATURE_base && !__SELECTED_FEATURE_base ) { foo(1); } else {foo(2);} }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.logContains("Found foo(2);"));
        Assert.assertFalse((boolean)results.logContains("Found foo(1);"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void ignoreVariable() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.featurevars.variableWhitelist", (Object)"trackNone");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        tmpFile.deleteOnExit();
        Files.writeFile((File)tmpFile, (Object)"OBSERVER AUTOMATON tmpAutomaton\nINITIAL STATE Init;\nSTATE Init :\nMATCH {$1} ->\nPRINT \"Found $1 in Line $line\" GOTO Init;\nEND AUTOMATON");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int __SELECTED_FEATURE_base; int main() { if (__SELECTED_FEATURE_base && !__SELECTED_FEATURE_base ) { foo(1); } else {foo(2);} }");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.logContains("Found foo(2);"));
        Assert.assertTrue((boolean)results.logContains("Found foo(1);"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void trackVariable2Vars() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.featurevars.variableWhitelist", (Object)"__SELECTED_FEATURE_(\\w)*");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        tmpFile.deleteOnExit();
        Files.writeFile((File)tmpFile, (Object)"OBSERVER AUTOMATON tmpAutomaton\nINITIAL STATE Init;\nSTATE Init :\nMATCH {$1} ->\nPRINT \"Found $1 in Line $line\" GOTO Init;\nEND AUTOMATON");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int __SELECTED_FEATURE_base; int __SELECTED_FEATURE_F2; int main() { if (__SELECTED_FEATURE_base && __SELECTED_FEATURE_F2 ){ if (! __SELECTED_FEATURE_F2 ) { foo(1); } else {foo(2);} }}");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.logContains("Found foo(2);"));
        Assert.assertFalse((boolean)results.logContains("Found foo(1);"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    @Test
    public void ignoreVariable2Vars() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.featurevariables.FeatureVarsCPA", (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cfa.removeIrrelevantForErrorLocations", (Object)"false", (Object)"cpa.featurevars.variableWhitelist", (Object)"");
        File tmpFile = new File("test/config/automata/tmpSpecification.spc");
        tmpFile.deleteOnExit();
        Files.writeFile((File)tmpFile, (Object)"OBSERVER AUTOMATON tmpAutomaton\nINITIAL STATE Init;\nSTATE Init :\nMATCH {$1} ->\nPRINT \"Found $1 in Line $line\" GOTO Init;\nEND AUTOMATON");
        File sourceFile = new File("test/programs/simple/tmpProgram.c");
        sourceFile.deleteOnExit();
        Files.writeFile((File)sourceFile, (Object)"int __SELECTED_FEATURE_base; int __SELECTED_FEATURE_F2; int main() { if (__SELECTED_FEATURE_base && __SELECTED_FEATURE_F2 ){ if (! __SELECTED_FEATURE_F2 ) { foo(1); } else {foo(2);} }}");
        TestResults results = this.run((Map<String, String>)prop, "test/programs/simple/tmpProgram.c");
        Assert.assertTrue((boolean)results.logContains("Found foo(2);"));
        Assert.assertTrue((boolean)results.logContains("Found foo(1);"));
        Assert.assertTrue((boolean)results.isSafe());
    }

    private TestResults run(Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        Configuration config = Configuration.builder().setOptions(pProperties).build();
        LogManager.StringHandler stringLogHandler = new LogManager.StringHandler();
        LogManager logger = new LogManager(config, (Handler)stringLogHandler);
        CPAchecker cpaChecker = new CPAchecker(config, logger);
        CPAcheckerResult results = cpaChecker.run(pSourceCodeFilePath);
        return new TestResults(stringLogHandler.getLog(), results);
    }

    private TestResults run(File configFile, Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        Configuration config = Configuration.builder().loadFromFile(configFile.getAbsolutePath()).setOptions(pProperties).build();
        LogManager.StringHandler stringLogHandler = new LogManager.StringHandler();
        LogManager logger = new LogManager(config, (Handler)stringLogHandler);
        CPAchecker cpaChecker = new CPAchecker(config, logger);
        CPAcheckerResult results = cpaChecker.run(pSourceCodeFilePath);
        return new TestResults(stringLogHandler.getLog(), results);
    }

    private static class TestResults {
        private String log;
        private CPAcheckerResult checkerResult;

        public TestResults(String pLog, CPAcheckerResult pCheckerResult) {
            this.log = pLog;
            this.checkerResult = pCheckerResult;
        }

        public String getLog() {
            return this.log;
        }

        public CPAcheckerResult getCheckerResult() {
            return this.checkerResult;
        }

        boolean logContains(String string) {
            return this.log.contains(string);
        }

        boolean logLineMatches(String pattern) {
            String[] lines = this.log.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].matches(pattern)) continue;
                return true;
            }
            return false;
        }

        boolean isSafe() {
            return this.checkerResult.getResult().equals((Object)CPAcheckerResult.Result.SAFE);
        }

        boolean isUnsafe() {
            return this.checkerResult.getResult().equals((Object)CPAcheckerResult.Result.UNSAFE);
        }

        public String toString() {
            return this.log;
        }
    }
}

