/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.featurevariables;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.MultiEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsElement;
import org.sosy_lab.cpachecker.cpa.featurevariables.FeatureVarsPrecision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

public class FeatureVarsTransferRelation
implements TransferRelation {
    private final NamedRegionManager rmgr;

    public FeatureVarsTransferRelation(NamedRegionManager manager) {
        this.rmgr = manager;
    }

    public Collection<FeatureVarsElement> getAbstractSuccessors(AbstractElement element, Precision pPrecision, CFAEdge cfaEdge) throws CPATransferException {
        FeatureVarsElement successor;
        Preconditions.checkArgument((boolean)(pPrecision instanceof FeatureVarsPrecision), (Object)"precision is no FeatureVarsPrecision");
        FeatureVarsPrecision precision = (FeatureVarsPrecision)pPrecision;
        FeatureVarsElement fvElement = (FeatureVarsElement)element;
        if (fvElement.getRegion().isFalse()) {
            return Collections.emptyList();
        }
        if (precision.isDisabled()) {
            return Collections.singleton(fvElement);
        }
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                successor = this.handleAssumption(fvElement, assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption(), precision);
                break;
            }
            case MultiEdge: {
                successor = fvElement;
                for (CFAEdge innerEdge : (MultiEdge)cfaEdge) {
                    successor = this.getAbstractSuccessor(successor, precision, innerEdge);
                }
            }
            default: {
                successor = this.getAbstractSuccessor(fvElement, precision, cfaEdge);
            }
        }
        if (successor == null) {
            return Collections.emptySet();
        }
        assert (!successor.getRegion().isFalse());
        return Collections.singleton(successor);
    }

    private FeatureVarsElement getAbstractSuccessor(FeatureVarsElement fvElement, FeatureVarsPrecision precision, CFAEdge cfaEdge) throws CPATransferException {
        FeatureVarsElement successor = fvElement;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge st = (StatementEdge)cfaEdge;
                successor = this.handleStatementEdge(fvElement, st.getStatement(), st, precision);
                break;
            }
            case ReturnStatementEdge: {
                break;
            }
            case DeclarationEdge: {
                break;
            }
            case BlankEdge: {
                break;
            }
            case FunctionCallEdge: {
                break;
            }
            case FunctionReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        assert (successor != null);
        assert (!successor.getRegion().isFalse());
        return successor;
    }

    private FeatureVarsElement handleStatementEdge(FeatureVarsElement element, IASTStatement pIastStatement, StatementEdge cfaEdge, FeatureVarsPrecision pPrecision) {
        IASTRightHandSide rhs;
        String varName;
        if (!(pIastStatement instanceof IASTAssignment)) {
            return element;
        }
        IASTAssignment assignment = (IASTAssignment)((Object)pIastStatement);
        IASTExpression lhs = assignment.getLeftHandSide();
        FeatureVarsElement result = element;
        if ((lhs instanceof IASTIdExpression || lhs instanceof IASTFieldReference || lhs instanceof IASTArraySubscriptExpression) && pPrecision.isOnWhitelist(varName = lhs.toASTString()) && (rhs = assignment.getRightHandSide()) instanceof IASTIntegerLiteralExpression) {
            String value = rhs.toASTString();
            if (value.trim().equals("0")) {
                Region operand = this.rmgr.makeNot(this.rmgr.createPredicate(varName));
                result = new FeatureVarsElement(this.rmgr.makeAnd(element.getRegion(), operand), this.rmgr);
            } else {
                Region operand = this.rmgr.createPredicate(varName);
                result = new FeatureVarsElement(this.rmgr.makeAnd(element.getRegion(), operand), this.rmgr);
            }
        }
        assert (!result.getRegion().isFalse());
        return result;
    }

    private FeatureVarsElement handleAssumption(FeatureVarsElement element, IASTExpression expression, CFAEdge cfaEdge, boolean truthValue, FeatureVarsPrecision precision) throws UnrecognizedCCodeException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        FeatureVarsElement result = this.handleBooleanExpression(element, expression, functionName, truthValue, precision, cfaEdge);
        if (result.getRegion().isFalse()) {
            return null;
        }
        return result;
    }

    private FeatureVarsElement handleBooleanExpression(FeatureVarsElement element, IASTExpression op, String functionName, boolean pTruthValue, FeatureVarsPrecision precision, CFAEdge edge) throws UnrecognizedCCodeException {
        Region operand = this.propagateBooleanExpression(element, op, functionName, precision, edge);
        if (operand == null) {
            return element;
        }
        Region newRegion = null;
        newRegion = pTruthValue ? this.rmgr.makeAnd(element.getRegion(), operand) : this.rmgr.makeAnd(element.getRegion(), this.rmgr.makeNot(operand));
        return new FeatureVarsElement(newRegion, this.rmgr);
    }

    private Region propagateBooleanExpression(FeatureVarsElement element, IASTExpression op, String functionName, FeatureVarsPrecision precision, CFAEdge edge) throws UnrecognizedCCodeException {
        Region operand = null;
        if (op instanceof IASTIdExpression || op instanceof IASTFieldReference || op instanceof IASTArraySubscriptExpression) {
            String varName = op.toASTString();
            if (!precision.isOnWhitelist(varName)) {
                return null;
            }
            operand = this.rmgr.createPredicate(varName);
        } else if (op instanceof IASTUnaryExpression) {
            operand = this.propagateUnaryBooleanExpression(element, ((IASTUnaryExpression)op).getOperator(), ((IASTUnaryExpression)op).getOperand(), functionName, precision, edge);
        } else if (op instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)op;
            operand = this.propagateBinaryBooleanExpression(element, binExp.getOperator(), binExp.getOperand1(), binExp.getOperand2(), functionName, precision, edge);
        }
        return operand;
    }

    private Region propagateUnaryBooleanExpression(FeatureVarsElement element, IASTUnaryExpression.UnaryOperator opType, IASTExpression op, String functionName, FeatureVarsPrecision precision, CFAEdge edge) throws UnrecognizedCCodeException {
        Region returnValue = null;
        Region operand = null;
        if (op instanceof IASTIdExpression || op instanceof IASTFieldReference || op instanceof IASTArraySubscriptExpression) {
            String varName = op.toASTString();
            if (!precision.isOnWhitelist(varName)) {
                return null;
            }
            operand = this.rmgr.createPredicate(varName);
        } else if (op instanceof IASTUnaryExpression) {
            operand = this.propagateUnaryBooleanExpression(element, ((IASTUnaryExpression)op).getOperator(), ((IASTUnaryExpression)op).getOperand(), functionName, precision, edge);
        } else if (op instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)op;
            operand = this.propagateBinaryBooleanExpression(element, binExp.getOperator(), binExp.getOperand1(), binExp.getOperand2(), functionName, precision, edge);
        }
        if (operand == null) {
            return null;
        }
        switch (opType) {
            case NOT: {
                returnValue = this.rmgr.makeNot(operand);
                break;
            }
            case STAR: {
                break;
            }
            default: {
                throw new UnrecognizedCCodeException("Unhandled case " + op.toASTString(), edge);
            }
        }
        return returnValue;
    }

    private Region propagateBinaryBooleanExpression(FeatureVarsElement element, IASTBinaryExpression.BinaryOperator opType, IASTExpression op1, IASTExpression op2, String functionName, FeatureVarsPrecision precision, CFAEdge edge) throws UnrecognizedCCodeException {
        Region operand1 = null;
        if (op1 instanceof IASTIdExpression || op1 instanceof IASTFieldReference || op1 instanceof IASTArraySubscriptExpression) {
            String varName = op1.toASTString();
            if (!precision.isOnWhitelist(varName)) {
                return null;
            }
            operand1 = this.rmgr.createPredicate(varName);
        } else if (op1 instanceof IASTUnaryExpression) {
            operand1 = this.propagateUnaryBooleanExpression(element, ((IASTUnaryExpression)op1).getOperator(), ((IASTUnaryExpression)op1).getOperand(), functionName, precision, edge);
        } else if (op1 instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)op1;
            operand1 = this.propagateBinaryBooleanExpression(element, binExp.getOperator(), binExp.getOperand1(), binExp.getOperand2(), functionName, precision, edge);
        }
        Region operand2 = null;
        if (op2 instanceof IASTIdExpression || op2 instanceof IASTFieldReference || op2 instanceof IASTArraySubscriptExpression) {
            String varName = op2.toASTString();
            if (!precision.isOnWhitelist(varName)) {
                return null;
            }
            operand2 = this.rmgr.createPredicate(varName);
        } else if (op2 instanceof IASTUnaryExpression) {
            operand2 = this.propagateUnaryBooleanExpression(element, ((IASTUnaryExpression)op2).getOperator(), ((IASTUnaryExpression)op2).getOperand(), functionName, precision, edge);
        } else if (op2 instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)op2;
            operand2 = this.propagateBinaryBooleanExpression(element, binExp.getOperator(), binExp.getOperand1(), binExp.getOperand2(), functionName, precision, edge);
        } else if (op2 instanceof IASTIntegerLiteralExpression) {
            IASTIntegerLiteralExpression number = (IASTIntegerLiteralExpression)op2;
            operand2 = number.getValue().equals(BigInteger.ZERO) ? this.rmgr.makeFalse() : this.rmgr.makeTrue();
        }
        if (operand1 == null || operand2 == null) {
            return null;
        }
        Region returnValue = null;
        switch (opType) {
            case LOGICAL_AND: {
                returnValue = this.rmgr.makeAnd(operand1, operand2);
                break;
            }
            case LOGICAL_OR: {
                returnValue = this.rmgr.makeOr(operand1, operand2);
                break;
            }
            case EQUALS: {
                returnValue = this.rmgr.makeOr(this.rmgr.makeAnd(operand1, operand2), this.rmgr.makeAnd(this.rmgr.makeNot(operand1), this.rmgr.makeNot(operand2)));
                break;
            }
            case NOT_EQUALS: {
                returnValue = this.rmgr.makeOr(this.rmgr.makeAnd(this.rmgr.makeNot(operand1), operand2), this.rmgr.makeAnd(operand1, this.rmgr.makeNot(operand2)));
                break;
            }
            default: {
                throw new UnrecognizedCCodeException("Cases ==, != and others are not implemented", edge);
            }
        }
        return returnValue;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> elements, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        return null;
    }
}

