/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;

class FunctionPointerElement
extends AbstractSingleWrapperElement {
    private final Map<String, FunctionPointerTarget> pointerVariableValues;

    private FunctionPointerElement(AbstractElement pWrappedElement) {
        super(pWrappedElement);
        this.pointerVariableValues = new HashMap<String, FunctionPointerTarget>(0);
    }

    private FunctionPointerElement(FunctionPointerElement pCopyFromPreviousState, AbstractElement pWrappedElement) {
        super(pWrappedElement);
        this.pointerVariableValues = new HashMap<String, FunctionPointerTarget>(pCopyFromPreviousState.pointerVariableValues);
    }

    public static FunctionPointerElement createEmptyElement(AbstractElement pWrappedElement) {
        return new FunctionPointerElement(pWrappedElement);
    }

    public FunctionPointerElement createDuplicateWithNewWrappedElement(AbstractElement pElement) {
        return new FunctionPointerElement(this, pElement);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\n FunctionPointerElement: [");
        Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(str, this.pointerVariableValues);
        str.append("]\n ");
        str.append(this.getWrappedElement());
        return str.toString();
    }

    public FunctionPointerTarget getTarget(String variableName) {
        return (FunctionPointerTarget)Objects.firstNonNull((Object)this.pointerVariableValues.get(variableName), (Object)UnknownTarget.getInstance());
    }

    public void setTarget(String variableName, FunctionPointerTarget target) {
        if (target == UnknownTarget.getInstance()) {
            this.pointerVariableValues.remove(variableName);
        } else {
            this.pointerVariableValues.put(variableName, target);
        }
    }

    public void clearVariablesWithPrefix(String prefix) {
        Iterator<String> it = this.pointerVariableValues.keySet().iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith(prefix)) continue;
            it.remove();
        }
    }

    public boolean isLessOrEqualThan(FunctionPointerElement pElement) {
        if (this.pointerVariableValues.size() < pElement.pointerVariableValues.size()) {
            return false;
        }
        for (Map.Entry<String, FunctionPointerTarget> entry : pElement.pointerVariableValues.entrySet()) {
            FunctionPointerTarget thisTarget = this.pointerVariableValues.get(entry.getKey());
            if (entry.getValue().equals(thisTarget)) continue;
            return false;
        }
        return true;
    }

    Map<String, FunctionPointerTarget> getTargetMap() {
        return this.pointerVariableValues;
    }

    static final class NamedFunctionTarget
    extends FunctionPointerTarget {
        private final String functionName;

        public NamedFunctionTarget(String pFunctionName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pFunctionName) ? 1 : 0) != 0);
            this.functionName = pFunctionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String toString() {
            return this.getFunctionName();
        }

        public boolean equals(Object pObj) {
            return pObj instanceof NamedFunctionTarget && ((NamedFunctionTarget)pObj).functionName.equals(this.functionName);
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }
    }

    static final class InvalidTarget
    extends FunctionPointerTarget {
        private static final InvalidTarget instance = new InvalidTarget();

        private InvalidTarget() {
        }

        public String toString() {
            return "INVALID";
        }

        public static InvalidTarget getInstance() {
            return instance;
        }

        public boolean equals(Object pObj) {
            return pObj instanceof InvalidTarget;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    static final class UnknownTarget
    extends FunctionPointerTarget {
        private static final UnknownTarget instance = new UnknownTarget();

        private UnknownTarget() {
        }

        public String toString() {
            return "UNKNOWN";
        }

        public static UnknownTarget getInstance() {
            return instance;
        }

        public boolean equals(Object pObj) {
            return pObj instanceof UnknownTarget;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    static abstract class FunctionPointerTarget {
        FunctionPointerTarget() {
        }
    }
}

