/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class FunctionPointerPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;

    public FunctionPointerPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision oldPrecision, UnmodifiableReachedSet pElements) throws CPAException {
        Preconditions.checkArgument((boolean)(pElement instanceof FunctionPointerElement));
        FunctionPointerElement element = (FunctionPointerElement)pElement;
        UnmodifiableReachedSetView elements = new UnmodifiableReachedSetView(pElements, ARTElement.getUnwrapFunction(), (Function<? super Precision, Precision>)Functions.identity());
        AbstractElement oldElement = element.getWrappedElement();
        Triple<AbstractElement, Precision, PrecisionAdjustment.Action> unwrappedResult = this.wrappedPrecAdjustment.prec(oldElement, oldPrecision, elements);
        AbstractElement newElement = (AbstractElement)unwrappedResult.getFirst();
        Precision newPrecision = (Precision)unwrappedResult.getSecond();
        PrecisionAdjustment.Action action = (PrecisionAdjustment.Action)((Object)unwrappedResult.getThird());
        if (oldElement == newElement && oldPrecision == newPrecision) {
            return new Triple((Object)pElement, (Object)oldPrecision, (Object)action);
        }
        FunctionPointerElement resultElement = element.createDuplicateWithNewWrappedElement(newElement);
        return new Triple((Object)resultElement, (Object)newPrecision, (Object)action);
    }
}

