/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerCallEdge;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerElement;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerReturnEdge;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.AbstractElements;

@Options(prefix="cpa.functionpointer")
class FunctionPointerTransferRelation
implements TransferRelation {
    private static final String FUNCTION_RETURN_VARIABLE = "__cpachecker_return_var";
    @Option(description="whether function pointers with invalid targets (e.g., 0) should be tracked in order to find calls to such pointers")
    private boolean trackInvalidFunctionPointers = false;
    private final FunctionPointerElement.FunctionPointerTarget invalidFunctionPointerTarget;
    private final TransferRelation wrappedTransfer;
    private final CFA functions;
    private final LogManager logger;

    FunctionPointerTransferRelation(TransferRelation pWrappedTransfer, CFA pCfa, LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.wrappedTransfer = pWrappedTransfer;
        this.functions = pCfa;
        this.logger = pLogger;
        this.invalidFunctionPointerTarget = this.trackInvalidFunctionPointers ? FunctionPointerElement.InvalidTarget.getInstance() : FunctionPointerElement.UnknownTarget.getInstance();
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        ArrayList<FunctionPointerElement> results;
        FunctionPointerElement oldState = (FunctionPointerElement)pElement;
        if (pCfaEdge == null) {
            CFANode node = AbstractElements.extractLocation(oldState);
            results = new ArrayList(node.getNumLeavingEdges());
            for (int edgeIdx = 0; edgeIdx < node.getNumLeavingEdges(); ++edgeIdx) {
                CFAEdge edge = node.getLeavingEdge(edgeIdx);
                if (edge instanceof FunctionPointerCallEdge) continue;
                this.getAbstractSuccessorForEdge(oldState, pPrecision, edge, results);
            }
        } else {
            results = new ArrayList<FunctionPointerElement>(1);
            this.getAbstractSuccessorForEdge(oldState, pPrecision, pCfaEdge, results);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getAbstractSuccessorForEdge(FunctionPointerElement oldState, Precision pPrecision, CFAEdge pCfaEdge, Collection<FunctionPointerElement> results) throws CPATransferException, InterruptedException {
        CFAEdge cfaEdge;
        block10: {
            block11: {
                String functionCallVariable = this.getFunctionPointerCall(pCfaEdge);
                if (functionCallVariable == null) break block11;
                FunctionPointerElement.FunctionPointerTarget target = oldState.getTarget(functionCallVariable);
                if (target instanceof FunctionPointerElement.NamedFunctionTarget) {
                    String functionName = ((FunctionPointerElement.NamedFunctionTarget)target).getFunctionName();
                    CFAFunctionDefinitionNode cFAFunctionDefinitionNode = this.functions.getFunctionHead(functionName);
                    if (cFAFunctionDefinitionNode == null) {
                        throw new UnrecognizedCCodeException("function pointer points to unknown function " + functionName, pCfaEdge);
                    }
                    this.logger.log(Level.FINEST, new Object[]{"Function pointer", functionCallVariable, "points to", target, "while it is used."});
                    StatementEdge edge = (StatementEdge)pCfaEdge;
                    IASTFunctionCall functionCall = (IASTFunctionCall)((Object)edge.getStatement());
                    CFANode predecessorNode = edge.getPredecessor();
                    CFANode successorNode = edge.getSuccessor();
                    int lineNumber = edge.getLineNumber();
                    CFAFunctionExitNode fExitNode = cFAFunctionDefinitionNode.getExitNode();
                    CallToReturnEdge calltoReturnEdge = new CallToReturnEdge(edge.getRawStatement(), lineNumber, predecessorNode, successorNode, functionCall);
                    FunctionPointerCallEdge callEdge = new FunctionPointerCallEdge(edge.getRawStatement(), lineNumber, predecessorNode, (FunctionDefinitionNode)cFAFunctionDefinitionNode, functionCall, calltoReturnEdge);
                    predecessorNode.addLeavingEdge(callEdge);
                    cFAFunctionDefinitionNode.addEnteringEdge(callEdge);
                    if (fExitNode.getNumEnteringEdges() > 0) {
                        FunctionPointerReturnEdge returnEdge = new FunctionPointerReturnEdge(lineNumber, fExitNode, successorNode, callEdge, calltoReturnEdge);
                        fExitNode.addLeavingEdge(returnEdge);
                        successorNode.addEnteringEdge(returnEdge);
                    }
                    cfaEdge = callEdge;
                    break block10;
                } else if (target instanceof FunctionPointerElement.UnknownTarget) {
                    cfaEdge = pCfaEdge;
                    break block10;
                } else {
                    if (target instanceof FunctionPointerElement.InvalidTarget) {
                        throw new UnrecognizedCCodeException("function pointer points to invalid memory address", pCfaEdge);
                    }
                    throw new AssertionError();
                }
            }
            cfaEdge = pCfaEdge;
        }
        if (cfaEdge instanceof FunctionPointerReturnEdge) {
            CallToReturnEdge calltoReturnEdge = ((FunctionPointerReturnEdge)cfaEdge).getSummaryEdge();
            calltoReturnEdge.getPredecessor().addLeavingSummaryEdge(calltoReturnEdge);
            calltoReturnEdge.getSuccessor().addEnteringSummaryEdge(calltoReturnEdge);
        }
        Collection<? extends AbstractElement> newWrappedStates = this.wrappedTransfer.getAbstractSuccessors(oldState.getWrappedElement(), pPrecision, cfaEdge);
        for (AbstractElement abstractElement : newWrappedStates) {
            FunctionPointerElement newState = oldState.createDuplicateWithNewWrappedElement(abstractElement);
            if ((newState = this.handleEdge(newState, cfaEdge)) == null) continue;
            results.add(newState);
        }
        if (pCfaEdge instanceof FunctionPointerReturnEdge) {
            FunctionPointerReturnEdge returnEdge = (FunctionPointerReturnEdge)pCfaEdge;
            CFACreationUtils.removeSummaryEdgeFromNodes(returnEdge.getSummaryEdge());
        }
    }

    private String getFunctionPointerCall(CFAEdge pCfaEdge) throws UnrecognizedCCodeException {
        if (pCfaEdge.getEdgeType() != CFAEdgeType.StatementEdge) {
            return null;
        }
        IASTStatement statement = ((StatementEdge)pCfaEdge).getStatement();
        if (!(statement instanceof IASTFunctionCall)) {
            return null;
        }
        IASTFunctionCallExpression funcCall = ((IASTFunctionCall)((Object)statement)).getFunctionCallExpression();
        IASTExpression nameExp = funcCall.getFunctionNameExpression();
        String currentFunction = pCfaEdge.getPredecessor().getFunctionName();
        if (nameExp instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExp = (IASTUnaryExpression)nameExp;
            if (unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                nameExp = unaryExp.getOperand();
            } else {
                throw new UnrecognizedCCodeException("unknown function call expression", pCfaEdge, nameExp);
            }
        }
        if (nameExp instanceof IASTIdExpression) {
            return FunctionPointerTransferRelation.scopedIfNecessary((IASTIdExpression)nameExp, currentFunction);
        }
        if (nameExp instanceof IASTFieldReference) {
            return null;
        }
        throw new UnrecognizedCCodeException("unknown function call expression", pCfaEdge, nameExp);
    }

    private FunctionPointerElement handleEdge(FunctionPointerElement newState, CFAEdge pCfaEdge) throws CPATransferException {
        switch (pCfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                DeclarationEdge declEdge = (DeclarationEdge)pCfaEdge;
                this.handleDeclaration(newState, declEdge);
                break;
            }
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)pCfaEdge;
                this.handleStatement(newState, statementEdge.getStatement(), pCfaEdge);
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)pCfaEdge;
                this.handleFunctionCall(newState, functionCallEdge);
                break;
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge returnStatementEdge = (ReturnStatementEdge)pCfaEdge;
                this.handleReturnStatement(newState, returnStatementEdge.getExpression(), pCfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)pCfaEdge;
                this.handleFunctionReturn(newState, functionReturnEdge);
                break;
            }
            case AssumeEdge: {
                break;
            }
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(pCfaEdge);
            }
        }
        return newState;
    }

    private void handleDeclaration(FunctionPointerElement pNewState, DeclarationEdge declEdge) throws UnrecognizedCCodeException {
        IASTInitializer init;
        if (!(declEdge.getDeclaration() instanceof IASTVariableDeclaration)) {
            return;
        }
        IASTVariableDeclaration decl = (IASTVariableDeclaration)declEdge.getDeclaration();
        String functionName = declEdge.getPredecessor().getFunctionName();
        String name = decl.getName();
        if (name == null) {
            return;
        }
        if (!decl.isGlobal()) {
            name = FunctionPointerTransferRelation.scoped(name, functionName);
        }
        FunctionPointerElement.FunctionPointerTarget initialValue = this.invalidFunctionPointerTarget;
        if (decl.getInitializer() != null && (init = decl.getInitializer()) instanceof IASTInitializerExpression) {
            initialValue = this.getValue(((IASTInitializerExpression)init).getExpression(), pNewState, functionName);
        }
        pNewState.setTarget(name, initialValue);
    }

    private void handleStatement(FunctionPointerElement pNewState, IASTStatement pStatement, CFAEdge pCfaEdge) throws UnrecognizedCCodeException {
        if (pStatement instanceof IASTAssignment) {
            String functionName = pCfaEdge.getPredecessor().getFunctionName();
            IASTAssignment assignment = (IASTAssignment)((Object)pStatement);
            String varName = this.getLeftHandSide(assignment.getLeftHandSide(), pCfaEdge, functionName);
            if (varName != null) {
                FunctionPointerElement.FunctionPointerTarget target = this.getValue(assignment.getRightHandSide(), pNewState, functionName);
                pNewState.setTarget(varName, target);
            }
        } else if (!(pStatement instanceof IASTFunctionCallStatement) && !(pStatement instanceof IASTExpressionStatement)) {
            throw new UnrecognizedCCodeException(pCfaEdge, pStatement);
        }
    }

    private void handleFunctionCall(FunctionPointerElement pNewState, FunctionCallEdge callEdge) throws UnrecognizedCCodeException {
        FunctionDefinitionNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<IASTExpression> arguments = callEdge.getArguments();
        if (functionEntryNode.getFunctionDefinition().getDeclSpecifier().takesVarArgs() ? paramNames.size() > arguments.size() : paramNames.size() != arguments.size()) {
            throw new UnrecognizedCCodeException("Number of parameters on function call does not match function definition", callEdge);
        }
        ExpressionValueVisitor v = new ExpressionValueVisitor(pNewState, callerFunctionName, this.invalidFunctionPointerTarget);
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = FunctionPointerTransferRelation.scoped(paramNames.get(i), calledFunctionName);
            IASTExpression actualArgument = arguments.get(i);
            FunctionPointerElement.FunctionPointerTarget target = ((IASTRightHandSide)actualArgument).accept(v);
            pNewState.setTarget(paramName, target);
        }
    }

    private void handleReturnStatement(FunctionPointerElement pNewState, IASTExpression returnValue, CFAEdge pCfaEdge) throws UnrecognizedCCodeException {
        if (returnValue != null) {
            String functionName = pCfaEdge.getPredecessor().getFunctionName();
            FunctionPointerElement.FunctionPointerTarget target = this.getValue(returnValue, pNewState, functionName);
            pNewState.setTarget(FUNCTION_RETURN_VARIABLE, target);
        }
    }

    private void handleFunctionReturn(FunctionPointerElement pNewState, FunctionReturnEdge pFunctionReturnEdge) throws UnrecognizedCCodeException {
        String callerFunction;
        IASTExpression left;
        String varName;
        CallToReturnEdge summaryEdge = pFunctionReturnEdge.getSuccessor().getEnteringSummaryEdge();
        assert (summaryEdge != null);
        IASTFunctionCall funcCall = summaryEdge.getExpression();
        if (funcCall instanceof IASTFunctionCallAssignmentStatement && (varName = this.getLeftHandSide(left = ((IASTFunctionCallAssignmentStatement)funcCall).getLeftHandSide(), summaryEdge, callerFunction = summaryEdge.getSuccessor().getFunctionName())) != null) {
            FunctionPointerElement.FunctionPointerTarget target = pNewState.getTarget(FUNCTION_RETURN_VARIABLE);
            pNewState.setTarget(varName, target);
        }
        pNewState.setTarget(FUNCTION_RETURN_VARIABLE, FunctionPointerElement.UnknownTarget.getInstance());
        String calledFunction = pFunctionReturnEdge.getPredecessor().getFunctionName();
        pNewState.clearVariablesWithPrefix(calledFunction + "::");
    }

    private String getLeftHandSide(IASTExpression lhsExpression, CFAEdge edge, String functionName) throws UnrecognizedCCodeException {
        if (lhsExpression instanceof IASTIdExpression) {
            return FunctionPointerTransferRelation.scopedIfNecessary((IASTIdExpression)lhsExpression, functionName);
        }
        if (!(lhsExpression instanceof IASTUnaryExpression && ((IASTUnaryExpression)lhsExpression).getOperator() == IASTUnaryExpression.UnaryOperator.STAR || lhsExpression instanceof IASTFieldReference || lhsExpression instanceof IASTArraySubscriptExpression)) {
            throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", edge, lhsExpression);
        }
        return null;
    }

    private FunctionPointerElement.FunctionPointerTarget getValue(IASTRightHandSide exp, FunctionPointerElement element, String function) throws UnrecognizedCCodeException {
        return exp.accept(new ExpressionValueVisitor(element, function, this.invalidFunctionPointerTarget));
    }

    private static String scopedIfNecessary(IASTIdExpression var, String function) {
        IASTSimpleDeclaration decl = var.getDeclaration();
        boolean isGlobal = false;
        if (decl instanceof IASTDeclaration) {
            isGlobal = ((IASTDeclaration)decl).isGlobal();
        }
        if (isGlobal) {
            return var.getName();
        }
        return FunctionPointerTransferRelation.scoped(var.getName(), function);
    }

    private static String scoped(String var, String function) {
        return function + "::" + var;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }

    private static class ExpressionValueVisitor
    extends DefaultExpressionVisitor<FunctionPointerElement.FunctionPointerTarget, UnrecognizedCCodeException>
    implements RightHandSideVisitor<FunctionPointerElement.FunctionPointerTarget, UnrecognizedCCodeException> {
        private final FunctionPointerElement element;
        private final String function;
        private final FunctionPointerElement.FunctionPointerTarget targetForInvalidPointers;

        private ExpressionValueVisitor(FunctionPointerElement pElement, String pFunction, FunctionPointerElement.FunctionPointerTarget pTargetForInvalidPointers) {
            this.element = pElement;
            this.function = pFunction;
            this.targetForInvalidPointers = pTargetForInvalidPointers;
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTUnaryExpression pE) {
            if (pE.getOperator() == IASTUnaryExpression.UnaryOperator.AMPER && pE.getOperand() instanceof IASTIdExpression) {
                IASTIdExpression operand = (IASTIdExpression)pE.getOperand();
                return new FunctionPointerElement.NamedFunctionTarget(operand.getName());
            }
            return this.visitDefault(pE);
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTIdExpression pE) {
            return this.element.getTarget(FunctionPointerTransferRelation.scopedIfNecessary(pE, this.function));
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTCastExpression pE) throws UnrecognizedCCodeException {
            return ((IASTRightHandSide)pE.getOperand()).accept(this);
        }

        @Override
        protected FunctionPointerElement.FunctionPointerTarget visitDefault(IASTExpression pExp) {
            return FunctionPointerElement.UnknownTarget.getInstance();
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTFunctionCallExpression pIastFunctionCallExpression) {
            return FunctionPointerElement.UnknownTarget.getInstance();
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTCharLiteralExpression pE) {
            return this.targetForInvalidPointers;
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTFloatLiteralExpression pE) {
            return this.targetForInvalidPointers;
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTIntegerLiteralExpression pE) {
            return this.targetForInvalidPointers;
        }

        @Override
        public FunctionPointerElement.FunctionPointerTarget visit(IASTStringLiteralExpression pE) {
            return this.targetForInvalidPointers;
        }
    }
}

