/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.guardededgeautomaton;

import java.util.ArrayList;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonPredicateElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonStandardElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.IGuardedEdgeAutomatonStateElement;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPGuard;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;

public abstract class GuardedEdgeAutomatonStateElement
implements GuardedEdgeAutomatonElement,
IGuardedEdgeAutomatonStateElement,
Targetable {
    private final NondeterministicFiniteAutomaton.State mAutomatonState;
    private final boolean mIsFinalState;

    public GuardedEdgeAutomatonStateElement(NondeterministicFiniteAutomaton.State pState, boolean pIsFinalState) {
        this.mAutomatonState = pState;
        this.mIsFinalState = pIsFinalState;
    }

    @Override
    public boolean isTarget() {
        return this.isFinalState();
    }

    @Override
    public final boolean isFinalState() {
        return this.mIsFinalState;
    }

    @Override
    public final NondeterministicFiniteAutomaton.State getAutomatonState() {
        return this.mAutomatonState;
    }

    public static GuardedEdgeAutomatonStateElement create(NondeterministicFiniteAutomaton.Edge pEdge, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        NondeterministicFiniteAutomaton.State lAutomatonState = pEdge.getTarget();
        GuardedEdgeLabel lLabel = (GuardedEdgeLabel)pEdge.getLabel();
        boolean lIsFinalState = pAutomaton.getFinalStates().contains(lAutomatonState);
        if (lLabel.hasGuards()) {
            ArrayList<ECPPredicate> lPredicates = new ArrayList<ECPPredicate>(lLabel.getNumberOfGuards());
            for (ECPGuard lGuard : lLabel) {
                assert (lGuard instanceof ECPPredicate);
                lPredicates.add((ECPPredicate)lGuard);
            }
            return new GuardedEdgeAutomatonPredicateElement(lAutomatonState, lPredicates, lIsFinalState);
        }
        return new GuardedEdgeAutomatonStandardElement(lAutomatonState, lIsFinalState);
    }

    public String toString() {
        return "GuardedEdgeAutomatonStateElement[" + this.mAutomatonState.toString() + "]@" + this.hashCode();
    }
}

