/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.guardededgeautomaton;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonDomain;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonPredicateElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonStandardElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonStateElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;

public class GuardedEdgeAutomatonTransferRelation
implements TransferRelation {
    private final NondeterministicFiniteAutomaton<GuardedEdgeLabel> mAutomaton;
    private final HashMap<NondeterministicFiniteAutomaton.Edge, GuardedEdgeAutomatonStateElement> mCache;
    private final HashSet<GuardedEdgeAutomatonStateElement> mSuccessors;

    public GuardedEdgeAutomatonTransferRelation(GuardedEdgeAutomatonDomain pDomain, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        this.mAutomaton = pAutomaton;
        this.mCache = new HashMap();
        HashMap<GuardedEdgeAutomatonStateElement, NondeterministicFiniteAutomaton.Edge> lTmpCache = new HashMap<GuardedEdgeAutomatonStateElement, NondeterministicFiniteAutomaton.Edge>();
        for (NondeterministicFiniteAutomaton.Edge lAutomatonEdge : pAutomaton.getEdges()) {
            GuardedEdgeAutomatonStateElement lElement = GuardedEdgeAutomatonStateElement.create(lAutomatonEdge, pAutomaton);
            if (lTmpCache.containsKey(lElement)) {
                lElement = this.mCache.get(lTmpCache.get(lElement));
            } else {
                lTmpCache.put(lElement, lAutomatonEdge);
            }
            this.mCache.put(lAutomatonEdge, lElement);
        }
        this.mSuccessors = new HashSet();
    }

    protected NondeterministicFiniteAutomaton<GuardedEdgeLabel> getAutomaton() {
        return this.mAutomaton;
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        if (pElement instanceof GuardedEdgeAutomatonPredicateElement) {
            throw new IllegalArgumentException();
        }
        GuardedEdgeAutomatonStandardElement lCurrentElement = (GuardedEdgeAutomatonStandardElement)pElement;
        this.mSuccessors.clear();
        for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : this.mAutomaton.getOutgoingEdges(lCurrentElement.getAutomatonState())) {
            GuardedEdgeLabel lLabel = (GuardedEdgeLabel)lOutgoingEdge.getLabel();
            if (!lLabel.contains(pCfaEdge)) continue;
            this.mSuccessors.add(this.mCache.get(lOutgoingEdge));
        }
        return this.mSuccessors;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        if (pElement instanceof GuardedEdgeAutomatonPredicateElement) {
            return Collections.singleton(((GuardedEdgeAutomatonPredicateElement)pElement).getStandardElement());
        }
        return null;
    }
}

