/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeDomain;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeStopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeTransferRelation;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonTransferRelation;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.progress.product.ProgressProductAutomatonPrecisionAdjustment;

public class ProductAutomatonCPA
extends CompositeCPA {
    public static ProductAutomatonCPA create(Collection<ConfigurableProgramAnalysis> pAutomatonCPAs, boolean pUseProgressPrecisionAdjustment) {
        Preconditions.checkNotNull(pAutomatonCPAs);
        Preconditions.checkArgument((pAutomatonCPAs.size() > 0 ? 1 : 0) != 0);
        ImmutableList.Builder domains = ImmutableList.builder();
        ImmutableList.Builder transferRelations = ImmutableList.builder();
        ImmutableList.Builder stopOperators = ImmutableList.builder();
        ImmutableList.Builder lCPAs = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : pAutomatonCPAs) {
            domains.add((Object)sp.getAbstractDomain());
            transferRelations.add((Object)sp.getTransferRelation());
            stopOperators.add((Object)sp.getStopOperator());
            lCPAs.add((Object)sp);
        }
        CompositeDomain compositeDomain = new CompositeDomain((ImmutableList<AbstractDomain>)domains.build());
        ProductAutomatonTransferRelation compositeTransfer = new ProductAutomatonTransferRelation((ImmutableList<TransferRelation>)transferRelations.build());
        CompositeStopOperator compositeStop = new CompositeStopOperator((ImmutableList<StopOperator>)stopOperators.build());
        return new ProductAutomatonCPA(compositeDomain, compositeTransfer, compositeStop, (ImmutableList<ConfigurableProgramAnalysis>)lCPAs.build(), pUseProgressPrecisionAdjustment);
    }

    public ProductAutomatonCPA(AbstractDomain abstractDomain, CompositeTransferRelation transferRelation, CompositeStopOperator stopOperator, ImmutableList<ConfigurableProgramAnalysis> cpas, boolean pUseProgressPrecisionAdjustment) {
        super(abstractDomain, transferRelation, new MergeSepOperator(), stopOperator, pUseProgressPrecisionAdjustment ? ProgressProductAutomatonPrecisionAdjustment.INSTANCE : ProductAutomatonPrecisionAdjustment.getInstance(), cpas);
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        CompositeElement lInitialElement = (CompositeElement)super.getInitialElement(node);
        return ProductAutomatonElement.createElement((List<AbstractElement>)lInitialElement.getWrappedElements());
    }
}

