/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.guardededgeautomaton.progress;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;

public class ProgressPrecision
implements Precision {
    private final Set<NondeterministicFiniteAutomaton.Edge> mProgressEdges;

    private ProgressPrecision(Set<NondeterministicFiniteAutomaton.Edge> pProgressEdges) {
        this.mProgressEdges = pProgressEdges;
    }

    public ProgressPrecision(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        this.mProgressEdges = new HashSet<NondeterministicFiniteAutomaton.Edge>();
        for (NondeterministicFiniteAutomaton.Edge lTransition : pAutomaton.getEdges()) {
            if (lTransition.getSource() == lTransition.getTarget()) continue;
            this.mProgressEdges.add(lTransition);
        }
    }

    public boolean isEmpty() {
        return this.mProgressEdges.isEmpty();
    }

    public boolean isProgress(NondeterministicFiniteAutomaton.Edge pTransition) {
        return this.mProgressEdges.contains(pTransition);
    }

    public ProgressPrecision remove(NondeterministicFiniteAutomaton.Edge pTransition) {
        if (this.mProgressEdges.contains(pTransition)) {
            ProgressPrecision lPrecision = new ProgressPrecision(new HashSet<NondeterministicFiniteAutomaton.Edge>(this.mProgressEdges));
            lPrecision.mProgressEdges.remove(pTransition);
            return lPrecision;
        }
        return this;
    }

    public int hashCode() {
        return ((Object)this.mProgressEdges).hashCode();
    }

    public boolean equals(Object pOther) {
        if (pOther == this) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass().equals(this.getClass())) {
            ProgressPrecision lPrecision = (ProgressPrecision)pOther;
            return ((Object)lPrecision.mProgressEdges).equals(this.mProgressEdges);
        }
        return false;
    }

    public String toString() {
        return this.mProgressEdges.toString();
    }
}

