/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.impact;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;

public abstract class ImpactAbstractElement
implements AbstractElement {
    private final PathFormula pathFormula;

    ImpactAbstractElement(PathFormula pPathFormula) {
        this.pathFormula = (PathFormula)Preconditions.checkNotNull((Object)pPathFormula);
    }

    public PathFormula getPathFormula() {
        return this.pathFormula;
    }

    public abstract boolean isAbstractionElement();

    public abstract Formula getStateFormula();

    public String toString() {
        return this.getStateFormula().toString();
    }

    static AbstractionElement getLastAbstraction(ImpactAbstractElement element) {
        if (element.isAbstractionElement()) {
            return (AbstractionElement)element;
        }
        return ((NonAbstractionElement)element).getLastAbstraction();
    }

    static class NonAbstractionElement
    extends ImpactAbstractElement {
        private final AbstractionElement lastAbstraction;
        private ImpactAbstractElement mergedInto = null;

        public NonAbstractionElement(PathFormula pPathFormula, AbstractionElement pLastAbstraction) {
            super(pPathFormula);
            this.lastAbstraction = (AbstractionElement)Preconditions.checkNotNull((Object)pLastAbstraction);
        }

        @Override
        public boolean isAbstractionElement() {
            return false;
        }

        public AbstractionElement getLastAbstraction() {
            return this.lastAbstraction;
        }

        ImpactAbstractElement getMergedInto() {
            return this.mergedInto;
        }

        void setMergedInto(ImpactAbstractElement pMergedInto) {
            Preconditions.checkNotNull((Object)pMergedInto);
            this.mergedInto = pMergedInto;
        }

        @Override
        public Formula getStateFormula() {
            return this.lastAbstraction.getStateFormula();
        }
    }

    public static class AbstractionElement
    extends ImpactAbstractElement {
        private final PathFormula blockFormula;
        private Formula stateFormula;

        AbstractionElement(PathFormula pPathFormula, Formula pStateFormula, PathFormula pBlockFormula) {
            super(pPathFormula);
            assert (pPathFormula.getFormula().isTrue());
            this.stateFormula = (Formula)Preconditions.checkNotNull((Object)pStateFormula);
            this.blockFormula = (PathFormula)Preconditions.checkNotNull((Object)pBlockFormula);
        }

        @Override
        public boolean isAbstractionElement() {
            return true;
        }

        public PathFormula getBlockFormula() {
            return this.blockFormula;
        }

        @Override
        public Formula getStateFormula() {
            return this.stateFormula;
        }

        public void setStateFormula(Formula pStateFormula) {
            this.stateFormula = (Formula)Preconditions.checkNotNull((Object)pStateFormula);
        }
    }
}

