/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.impact;

import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.impact.ImpactAbstractDomain;
import org.sosy_lab.cpachecker.cpa.impact.ImpactAbstractElement;
import org.sosy_lab.cpachecker.cpa.impact.ImpactMergeOperator;
import org.sosy_lab.cpachecker.cpa.impact.ImpactTransferRelation;
import org.sosy_lab.cpachecker.cpa.predicate.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;

public class ImpactCPA
implements ConfigurableProgramAnalysis {
    private final Configuration config;
    private final LogManager logger;
    private final ExtendedFormulaManager fmgr;
    private final PathFormulaManager pfmgr;
    private final Solver solver;
    private final FormulaManagerFactory factory;
    private final AbstractDomain abstractDomain;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final TransferRelation transferRelation;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ImpactCPA.class).withOptions(BlockOperator.class);
    }

    private ImpactCPA(Configuration pConfig, LogManager pLogger, BlockOperator blk) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.factory = new FormulaManagerFactory(pConfig, pLogger);
        this.fmgr = new ExtendedFormulaManager(this.factory.getFormulaManager(), pConfig, pLogger);
        this.pfmgr = new CachingPathFormulaManager(new PathFormulaManagerImpl(this.fmgr, this.config, this.logger));
        TheoremProver prover = this.factory.createTheoremProver();
        this.solver = new Solver(this.fmgr, prover);
        this.abstractDomain = new ImpactAbstractDomain(this.solver);
        this.mergeOperator = new ImpactMergeOperator(this.logger, this.pfmgr);
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = new ImpactTransferRelation(this.logger, blk, this.fmgr, this.pfmgr, this.solver);
    }

    public LogManager getLogManager() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public ExtendedFormulaManager getFormulaManager() {
        return this.fmgr;
    }

    public PathFormulaManager getPathFormulaManager() {
        return this.pfmgr;
    }

    public Solver getSolver() {
        return this.solver;
    }

    FormulaManagerFactory getFormulaManagerFactory() {
        return this.factory;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        return new ImpactAbstractElement.AbstractionElement(this.pfmgr.makeEmptyPathFormula(), this.fmgr.makeTrue(), this.pfmgr.makeEmptyPathFormula());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }
}

