/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.impact;

import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.impact.ImpactAbstractElement;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

class ImpactMergeOperator
implements MergeOperator {
    private final LogManager logger;
    private final PathFormulaManager formulaManager;
    final Timer totalMergeTime = new Timer();

    public ImpactMergeOperator(LogManager pLogger, PathFormulaManager pPfmgr) {
        this.logger = pLogger;
        this.formulaManager = pPfmgr;
    }

    @Override
    public AbstractElement merge(AbstractElement element1, AbstractElement element2, Precision precision) {
        ImpactAbstractElement merged;
        ImpactAbstractElement elem1 = (ImpactAbstractElement)element1;
        ImpactAbstractElement elem2 = (ImpactAbstractElement)element2;
        if (elem1.isAbstractionElement() || elem2.isAbstractionElement()) {
            merged = elem2;
        } else {
            ImpactAbstractElement.AbstractionElement absElement2;
            ImpactAbstractElement.AbstractionElement absElement1 = ImpactAbstractElement.getLastAbstraction(elem1);
            if (absElement1 != (absElement2 = ImpactAbstractElement.getLastAbstraction(elem2))) {
                merged = elem2;
            } else {
                this.totalMergeTime.start();
                this.logger.log(Level.FINEST, new Object[]{"Merging two non-abstraction nodes."});
                PathFormula pathFormula = this.formulaManager.makeOr(elem1.getPathFormula(), elem2.getPathFormula());
                this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
                merged = new ImpactAbstractElement.NonAbstractionElement(pathFormula, absElement1);
                ((ImpactAbstractElement.NonAbstractionElement)elem1).setMergedInto(merged);
                this.totalMergeTime.stop();
            }
        }
        return merged;
    }
}

