/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.impact;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTUtils;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.impact.ImpactAbstractElement;
import org.sosy_lab.cpachecker.cpa.impact.ImpactCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interpolation.AbstractInterpolationBasedRefiner;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.UninstantiatingInterpolationManager;

public class ImpactRefiner
extends AbstractInterpolationBasedRefiner<Formula, ARTElement>
implements StatisticsProvider {
    protected final ExtendedFormulaManager fmgr;
    protected final Solver solver;
    private final Stats stats = new Stats();

    public static ImpactRefiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        ImpactCPA impactCpa = (ImpactCPA)Iterables.getFirst((Iterable)Iterables.filter(CPAs.asIterable(pCpa), ImpactCPA.class), null);
        if (impactCpa == null) {
            throw new InvalidConfigurationException(ImpactRefiner.class.getSimpleName() + " needs an ImpactCPA");
        }
        Configuration config = impactCpa.getConfiguration();
        LogManager logger = impactCpa.getLogManager();
        ExtendedFormulaManager fmgr = impactCpa.getFormulaManager();
        Solver solver = impactCpa.getSolver();
        UninstantiatingInterpolationManager manager = new UninstantiatingInterpolationManager(fmgr, impactCpa.getPathFormulaManager(), solver, impactCpa.getFormulaManagerFactory(), config, logger);
        return new ImpactRefiner(config, logger, pCpa, manager, fmgr, solver);
    }

    protected ImpactRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis pCpa, InterpolationManager<Formula> pInterpolationManager, ExtendedFormulaManager pFmgr, Solver pSolver) throws InvalidConfigurationException, CPAException {
        super(config, logger, pCpa, pInterpolationManager);
        this.solver = pSolver;
        this.fmgr = pFmgr;
    }

    @Override
    protected List<ARTElement> transformPath(Path pPath) {
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.skip((Iterable)pPath, (int)1), (Function)Pair.getProjectionToFirst()), (Predicate)new Predicate<ARTElement>(){

            public boolean apply(ARTElement pInput) {
                return AbstractElements.extractElementByType(pInput, ImpactAbstractElement.class).isAbstractionElement();
            }
        }));
        assert (((Pair)pPath.getLast()).getFirst() == result.get(result.size() - 1));
        return result;
    }

    @Override
    protected List<Formula> getFormulasForPath(List<ARTElement> pPath, ARTElement pInitialElement) {
        return Lists.transform(pPath, (Function)new Function<ARTElement, Formula>(){

            public Formula apply(ARTElement e) {
                return AbstractElements.extractElementByType(e, ImpactAbstractElement.AbstractionElement.class).getBlockFormula().getFormula();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefinement(ARTReachedSet pReached, List<ARTElement> path, CounterexampleTraceInfo<Formula> cex, boolean pRepeatedCounterexample) throws CPAException {
        ReachedSet reached = pReached.asReachedSet();
        ARTElement lastElement = path.get(path.size() - 1);
        assert (lastElement.isTarget());
        path = path.subList(0, path.size() - 1);
        assert (cex.getPredicatesForRefinement().size() == path.size());
        ArrayList<ARTElement> changedElements = new ArrayList<ARTElement>();
        ARTElement infeasiblePartOfART = lastElement;
        for (Pair interpolationPoint : Pair.zipList(cex.getPredicatesForRefinement(), path)) {
            Formula itp = (Formula)interpolationPoint.getFirst();
            ARTElement w = (ARTElement)interpolationPoint.getSecond();
            if (itp.isTrue()) continue;
            if (itp.isFalse()) {
                infeasiblePartOfART = w;
                break;
            }
            Formula stateFormula = this.getStateFormula(w);
            this.stats.itpCheck.start();
            boolean isNewItp = !this.solver.implies(stateFormula, itp);
            this.stats.itpCheck.stop();
            if (!isNewItp) continue;
            this.stats.newItpWasAdded++;
            this.addFormulaToState(itp, w);
            changedElements.add(w);
        }
        if (changedElements.isEmpty() && pRepeatedCounterexample) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, null);
        }
        this.stats.artUpdate.start();
        for (ARTElement w : changedElements) {
            this.removeCoverageOf(w, reached);
        }
        Set<ARTElement> infeasibleSubtree = infeasiblePartOfART.getSubtree();
        assert (infeasibleSubtree.contains(lastElement));
        this.uncover(infeasibleSubtree, reached);
        for (ARTElement removedNode : infeasibleSubtree) {
            removedNode.removeFromART();
        }
        reached.removeAll(infeasibleSubtree);
        this.stats.artUpdate.stop();
        this.stats.coverTime.start();
        try {
            for (ARTElement w : changedElements) {
                if (!this.cover(w, reached)) continue;
                break;
            }
        }
        finally {
            this.stats.coverTime.stop();
        }
        assert (!reached.contains(lastElement));
    }

    private boolean cover(ARTElement v, ReachedSet reached) throws CPAException {
        assert (v.mayCover());
        this.getArtCpa().getStopOperator().stop(v, reached.getReached(v), reached.getPrecision(v));
        if (v.isCovered()) {
            reached.removeOnlyFromWaitlist(v);
            Set<ARTElement> subtree = v.getSubtree();
            this.uncover(subtree, reached);
            subtree.remove(v);
            for (ARTElement childOfV : subtree) {
                if (childOfV.isCovered()) {
                    childOfV.uncover();
                }
                reached.removeOnlyFromWaitlist(childOfV);
                childOfV.setNotCovering();
            }
            for (ARTElement childOfV : subtree) {
                assert (childOfV.getCoveredByThis().isEmpty());
                assert (!childOfV.mayCover());
            }
            assert (!reached.getWaitlist().contains(v.getSubtree()));
            return true;
        }
        return false;
    }

    private void removeCoverageOf(ARTElement v, ReachedSet reached) {
        for (ARTElement coveredByChildOfV : ImmutableList.copyOf(v.getCoveredByThis())) {
            this.uncover(coveredByChildOfV, reached);
        }
        assert (v.getCoveredByThis().isEmpty());
    }

    private void uncover(Set<ARTElement> subtree, ReachedSet reached) {
        Set<ARTElement> coveredStates = ARTUtils.getCoveredBy(subtree);
        for (ARTElement coveredState : coveredStates) {
            this.uncover(coveredState, reached);
        }
        assert (ARTUtils.getCoveredBy(subtree).isEmpty()) : "Subtree of covered node still covers other elements";
    }

    private void uncover(ARTElement v, ReachedSet reached) {
        v.uncover();
        Set<ARTElement> uncoveredSubTree = v.getSubtree();
        for (ARTElement e : uncoveredSubTree) {
            assert (!e.isCovered());
            e.setCovering();
            if (e.wasExpanded()) continue;
            reached.reAddToWaitlist(e);
        }
    }

    protected Formula getStateFormula(ARTElement pARTElement) {
        return AbstractElements.extractElementByType(pARTElement, ImpactAbstractElement.AbstractionElement.class).getStateFormula();
    }

    protected void addFormulaToState(Formula f, ARTElement pARTElement) {
        ImpactAbstractElement.AbstractionElement e = AbstractElements.extractElementByType(pARTElement, ImpactAbstractElement.AbstractionElement.class);
        e.setStateFormula(this.fmgr.makeAnd(f, e.getStateFormula()));
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private class Stats
    implements Statistics {
        private int newItpWasAdded = 0;
        private final Timer itpCheck = new Timer();
        private final Timer coverTime = new Timer();
        private final Timer artUpdate = new Timer();

        private Stats() {
        }

        @Override
        public String getName() {
            return "Impact Refiner";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            ImpactRefiner.this.printStatistics(out, pResult, pReached);
            out.println("  Checking whether itp is new:    " + this.itpCheck);
            out.println("  Coverage checks:                " + this.coverTime);
            out.println("  ART update:                     " + this.artUpdate);
            out.println();
            out.println("Number of interpolants added:     " + this.newItpWasAdded);
            out.println("Number of non-new interpolants:   " + (this.itpCheck.getNumberOfIntervals() - this.newItpWasAdded));
        }
    }
}

