/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.impact;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.impact.ImpactAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.BlockOperator;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

class ImpactTransferRelation
implements TransferRelation {
    private final LogManager logger;
    private final BlockOperator blk;
    private final FormulaManager fmgr;
    private final PathFormulaManager pfmgr;
    private final Solver solver;

    public ImpactTransferRelation(LogManager pLogger, BlockOperator pBlk, FormulaManager pFmgr, PathFormulaManager pPfmgr, Solver pSolver) {
        this.logger = pLogger;
        this.blk = pBlk;
        this.fmgr = pFmgr;
        this.pfmgr = pPfmgr;
        this.solver = pSolver;
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        ImpactAbstractElement newElement;
        ImpactAbstractElement element = (ImpactAbstractElement)pElement;
        PathFormula newPathFormula = this.pfmgr.makeAnd(element.getPathFormula(), pCfaEdge);
        if (this.blk.isBlockEnd(pCfaEdge, newPathFormula)) {
            PathFormula blockFormula = newPathFormula;
            newPathFormula = this.pfmgr.makeEmptyPathFormula(blockFormula);
            newElement = new ImpactAbstractElement.AbstractionElement(newPathFormula, this.fmgr.makeTrue(), blockFormula);
        } else {
            newElement = new ImpactAbstractElement.NonAbstractionElement(newPathFormula, ImpactAbstractElement.getLastAbstraction(element));
        }
        return Collections.singleton(newElement);
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        ImpactAbstractElement element = (ImpactAbstractElement)pElement;
        if (element.isAbstractionElement()) {
            return null;
        }
        for (AbstractElement lElement : pOtherElements) {
            if (!AbstractElements.isTargetElement(lElement)) continue;
            return this.strengthenSatCheck(element);
        }
        return null;
    }

    private Collection<? extends AbstractElement> strengthenSatCheck(ImpactAbstractElement pElement) {
        this.logger.log(Level.FINEST, new Object[]{"Checking for feasibility of path because error has been found"});
        Formula f = this.fmgr.makeAnd(pElement.getStateFormula(), pElement.getPathFormula().getFormula());
        if (this.solver.isUnsat(f)) {
            this.logger.log(Level.FINEST, new Object[]{"Path is infeasible."});
            return Collections.emptySet();
        }
        this.logger.log(Level.FINEST, new Object[]{"Last part of the path is not infeasible."});
        PathFormula blockFormula = pElement.getPathFormula();
        PathFormula newPathFormula = this.pfmgr.makeEmptyPathFormula(blockFormula);
        return Collections.singleton(new ImpactAbstractElement.AbstractionElement(newPathFormula, this.fmgr.makeTrue(), blockFormula));
    }
}

