/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interpreter;

import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopNeverOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterDomain;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterElement;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterInputExtendingTransferRelation;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterTransferRelation;

public class InterpreterCPA
implements ConfigurableProgramAnalysis {
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private TransferRelation transferRelation;
    private PrecisionAdjustment precisionAdjustment;
    private int[] mInitialValuesForNondeterministicAssignments;

    public InterpreterCPA(int[] pInitialValuesForNondeterministicAssignments) {
        this(pInitialValuesForNondeterministicAssignments, false);
    }

    public InterpreterCPA(int[] pInitialValuesForNondeterministicAssignments, boolean pExtendInputs) {
        if (pInitialValuesForNondeterministicAssignments == null) {
            throw new IllegalArgumentException();
        }
        InterpreterDomain lDomain = new InterpreterDomain();
        MergeOperator lMergeOp = MergeSepOperator.getInstance();
        StopOperator lStopOp = StopNeverOperator.getInstance();
        InterpreterTransferRelation lTransferRelation = pExtendInputs ? new InterpreterInputExtendingTransferRelation() : new InterpreterTransferRelation();
        this.abstractDomain = lDomain;
        this.mergeOperator = lMergeOp;
        this.stopOperator = lStopOp;
        this.transferRelation = lTransferRelation;
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        this.mInitialValuesForNondeterministicAssignments = pInitialValuesForNondeterministicAssignments;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        return new InterpreterElement(this.mInitialValuesForNondeterministicAssignments);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }
}

