/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interpreter;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.junit.Test;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.cfa.Wrapper;

public class InterpreterCPATest {
    @Test
    public void test001() throws Exception {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        LogManager lLogManager;
        Configuration lConfiguration;
        ConfigurableProgramAnalysis lCallStackCPA;
        ConfigurableProgramAnalysis lLocationCPA;
        try {
            lLocationCPA = LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            lCallStackCPA = lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(lLocationCPA);
        lComponentAnalyses.add(lCallStackCPA);
        int[] lInputs = new int[]{};
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(lInputs);
        lComponentAnalyses.add(lInterpreterCPA);
        String lSourceFileName = "test/programs/fql/locks/test_locks_1.c";
        String lEntryFunction = "main";
        try {
            lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
            lLogManager = new LogManager(lConfiguration);
            lCFAMap = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager);
            lMainFunction = lCFAMap.get(lEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        Wrapper lWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, lLogManager);
        try {
            lWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(lConfiguration);
        lCPAFactory.setLogger(lLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, lLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(lWrapper.getEntry());
        Precision lInitialPrecision = lCPA.getInitialPrecision(lWrapper.getEntry());
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void test002() throws Exception {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        LogManager lLogManager;
        Configuration lConfiguration;
        ConfigurableProgramAnalysis lCallStackCPA;
        ConfigurableProgramAnalysis lLocationCPA;
        try {
            lLocationCPA = LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            lCallStackCPA = lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(lLocationCPA);
        lComponentAnalyses.add(lCallStackCPA);
        int[] lInputs = new int[]{1, 0, 0};
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(lInputs);
        lComponentAnalyses.add(lInterpreterCPA);
        String lSourceFileName = "test/programs/fql/locks/test_locks_1.c";
        String lEntryFunction = "main";
        try {
            lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
            lLogManager = new LogManager(lConfiguration);
            lCFAMap = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager);
            lMainFunction = lCFAMap.get(lEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        Wrapper lWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, lLogManager);
        try {
            lWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(lConfiguration);
        lCPAFactory.setLogger(lLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, lLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(lWrapper.getEntry());
        Precision lInitialPrecision = lCPA.getInitialPrecision(lWrapper.getEntry());
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void test003() throws Exception {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        LogManager lLogManager;
        Configuration lConfiguration;
        ConfigurableProgramAnalysis lCallStackCPA;
        ConfigurableProgramAnalysis lLocationCPA;
        try {
            lLocationCPA = LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            lCallStackCPA = lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(lLocationCPA);
        lComponentAnalyses.add(lCallStackCPA);
        int[] lInputs = new int[]{};
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(lInputs, true);
        lComponentAnalyses.add(lInterpreterCPA);
        String lSourceFileName = "test/programs/fql/locks/test_locks_1.c";
        String lEntryFunction = "main";
        try {
            lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
            lLogManager = new LogManager(lConfiguration);
            lCFAMap = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager);
            lMainFunction = lCFAMap.get(lEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        Wrapper lWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, lLogManager);
        try {
            lWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(lConfiguration);
        lCPAFactory.setLogger(lLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, lLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(lWrapper.getEntry());
        Precision lInitialPrecision = lCPA.getInitialPrecision(lWrapper.getEntry());
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void test004() throws Exception {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        LogManager lLogManager;
        Configuration lConfiguration;
        ConfigurableProgramAnalysis lCallStackCPA;
        ConfigurableProgramAnalysis lLocationCPA;
        try {
            lLocationCPA = LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            lCallStackCPA = lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(lLocationCPA);
        lComponentAnalyses.add(lCallStackCPA);
        int[] lInputs = new int[]{};
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(lInputs, true);
        lComponentAnalyses.add(lInterpreterCPA);
        String lSourceFileName = "test/programs/fql/ntdrivers-simplified/cdaudio_simpl1_BUG.cil.c";
        String lEntryFunction = "main";
        try {
            lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
            lLogManager = new LogManager(lConfiguration);
            lCFAMap = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager);
            lMainFunction = lCFAMap.get(lEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        Wrapper lWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, lLogManager);
        try {
            lWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(lConfiguration);
        lCPAFactory.setLogger(lLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, lLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(lWrapper.getEntry());
        Precision lInitialPrecision = lCPA.getInitialPrecision(lWrapper.getEntry());
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
    }
}

