/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interpreter;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.interpreter.exceptions.AccessToUninitializedVariableException;
import org.sosy_lab.cpachecker.cpa.interpreter.exceptions.MissingInputException;

public class InterpreterElement
implements AbstractElement {
    private final Map<String, Long> mConstantsMap;
    private final InterpreterElement mPreviousElement;
    private int mInputIndex;
    private int[] mInputs;

    public InterpreterElement() {
        this(new int[0]);
    }

    public InterpreterElement(int[] pInputs) {
        this(new HashMap<String, Long>(), null, 0, pInputs);
    }

    public InterpreterElement(InterpreterElement pPreviousContextElement, int pInputIndex, int[] pInputs) {
        this(new HashMap<String, Long>(), pPreviousContextElement, pInputIndex, pInputs);
    }

    public InterpreterElement(Map<String, Long> pConstantsMap, InterpreterElement pPreviousContextElement, int pInputIndex, int[] pInputs) {
        if (pInputs == null) {
            throw new IllegalArgumentException();
        }
        this.mConstantsMap = pConstantsMap;
        this.mPreviousElement = pPreviousContextElement;
        this.mInputIndex = pInputIndex;
        this.mInputs = pInputs;
    }

    public int getInputIndex() {
        return this.mInputIndex;
    }

    public int[] getInputs() {
        return this.mInputs;
    }

    private void setInputIndex(int pIndex) {
        this.mInputIndex = pIndex;
    }

    private void incIndex() {
        ++this.mInputIndex;
    }

    public int getCurrentInput() throws MissingInputException {
        if (this.mInputIndex < 0) {
            throw new RuntimeException("Input index is 0");
        }
        if (this.mInputIndex >= this.mInputs.length) {
            throw new MissingInputException("__BLAST_NONDET");
        }
        return this.mInputs[this.mInputIndex];
    }

    public void assignConstant(String nameOfVar, long value) {
        if (this.mConstantsMap.containsKey(nameOfVar) && this.mConstantsMap.get(nameOfVar) == value) {
            return;
        }
        this.mConstantsMap.put(nameOfVar, value);
    }

    public long getValueFor(String pVariableName) throws AccessToUninitializedVariableException {
        if (!this.mConstantsMap.containsKey(pVariableName)) {
            throw new AccessToUninitializedVariableException(pVariableName);
        }
        return this.mConstantsMap.get(pVariableName);
    }

    public boolean contains(String variableName) {
        return this.mConstantsMap.containsKey(variableName);
    }

    public InterpreterElement getPreviousElement() {
        return this.mPreviousElement;
    }

    public InterpreterElement nextInputElement() {
        InterpreterElement lTmpElement = this.clone();
        lTmpElement.incIndex();
        return lTmpElement;
    }

    public InterpreterElement getUpdatedPreviousElement() {
        InterpreterElement previousElem = this.getPreviousElement();
        InterpreterElement newElement = previousElem.clone();
        newElement.mInputs = this.mInputs;
        newElement.setInputIndex(this.getInputIndex());
        return newElement;
    }

    public InterpreterElement clone() {
        InterpreterElement newElement = new InterpreterElement(this.mPreviousElement, this.mInputIndex, this.mInputs);
        for (String s : this.mConstantsMap.keySet()) {
            long val = this.mConstantsMap.get(s);
            newElement.mConstantsMap.put(s, val);
        }
        return newElement;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        InterpreterElement otherElement = (InterpreterElement)other;
        if (otherElement.mConstantsMap.size() != this.mConstantsMap.size()) {
            return false;
        }
        if (this.mInputIndex != otherElement.mInputIndex) {
            return false;
        }
        if (this.mInputs.length != otherElement.mInputs.length) {
            return false;
        }
        for (int lIndex = 0; lIndex < this.mInputs.length; ++lIndex) {
            if (this.mInputs[lIndex] == otherElement.mInputs[lIndex]) continue;
            return false;
        }
        for (String s : this.mConstantsMap.keySet()) {
            if (!otherElement.mConstantsMap.containsKey(s)) {
                return false;
            }
            if (otherElement.mConstantsMap.get(s).longValue() == this.mConstantsMap.get(s).longValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.mConstantsMap).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").appendTo(sb, Arrays.asList(new int[][]{this.mInputs}));
        sb.append("}[");
        sb.append(this.mInputIndex);
        sb.append("] [");
        for (Map.Entry<String, Long> entry : this.mConstantsMap.entrySet()) {
            String key = entry.getKey();
            long val = entry.getValue();
            sb.append(" <");
            sb.append(key);
            sb.append(" = ");
            sb.append(val);
            sb.append("> ");
        }
        return sb.append("] size->  ").append(this.mConstantsMap.size()).toString();
    }

    public Map<String, Long> getConstantsMap() {
        return this.mConstantsMap;
    }

    public void forget(String assignedVar) {
        if (this.mConstantsMap.containsKey(assignedVar)) {
            this.mConstantsMap.remove(assignedVar);
        }
        throw new RuntimeException();
    }
}

