/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interpreter;

import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterElement;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterTransferRelation;
import org.sosy_lab.cpachecker.cpa.interpreter.exceptions.MissingInputException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class InterpreterInputExtendingTransferRelation
extends InterpreterTransferRelation {
    private final boolean mPureRandomInputExtension;
    private final int mInputVectorSizeThreshold;

    public InterpreterInputExtendingTransferRelation() {
        this(false, 20);
    }

    public InterpreterInputExtendingTransferRelation(boolean pPureRandomInputExtension, int pInputVectorSizeThreshold) {
        this.mPureRandomInputExtension = pPureRandomInputExtension;
        this.mInputVectorSizeThreshold = pInputVectorSizeThreshold;
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        Collection<? extends AbstractElement> lSuccessors = null;
        boolean lRedo = false;
        do {
            try {
                lSuccessors = super.getAbstractSuccessors(pElement, pPrecision, pCfaEdge);
                lRedo = false;
            }
            catch (MissingInputException e) {
                InterpreterElement lElement = (InterpreterElement)pElement;
                int[] lInputs = new int[lElement.getInputs().length + 1];
                for (int lIndex = 0; lIndex < lInputs.length - 1; ++lIndex) {
                    lInputs[lIndex] = lElement.getInputs()[lIndex];
                }
                if (this.mPureRandomInputExtension || Math.random() > 0.25) {
                    long lMaxInt = Integer.MAX_VALUE;
                    long lMinInt = Integer.MIN_VALUE;
                    long lRange = lMaxInt - lMinInt;
                    long lRandomValue = (long)(Math.random() * (double)lRange) + lMinInt;
                    lInputs[lInputs.length - 1] = (int)lRandomValue;
                } else {
                    lInputs[lInputs.length - 1] = 0;
                }
                InterpreterElement lTmpElement = new InterpreterElement(lElement.getConstantsMap(), lElement.getPreviousElement(), lElement.getInputIndex(), lInputs);
                pElement = lTmpElement;
                if (lInputs.length > this.mInputVectorSizeThreshold) {
                    throw e;
                }
                lRedo = true;
            }
        } while (lRedo);
        return lSuccessors;
    }
}

