/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.assume.ConstrainedAssumeElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonPredicateElement;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterBottomElement;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterElement;
import org.sosy_lab.cpachecker.cpa.interpreter.exceptions.AccessToUninitializedVariableException;
import org.sosy_lab.cpachecker.cpa.interpreter.exceptions.MissingInputException;
import org.sosy_lab.cpachecker.cpa.pointer.Memory;
import org.sosy_lab.cpachecker.cpa.pointer.Pointer;
import org.sosy_lab.cpachecker.cpa.pointer.PointerElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.fshell.fql2.translators.cfa.ToFlleShAssumeEdgeTranslator;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;

public class InterpreterTransferRelation
implements TransferRelation {
    private final Set<String> globalVars = new HashSet<String>();
    private String missingInformationLeftVariable = null;
    private String missingInformationRightPointer = null;
    private String missingInformationLeftPointer = null;
    private IASTExpression missingInformationRightExpression = null;

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        AbstractElement successor;
        InterpreterElement explicitElement = (InterpreterElement)element;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)cfaEdge;
                successor = this.handleStatement(explicitElement, statementEdge.getStatement(), cfaEdge);
                if (successor != null) break;
                throw new RuntimeException();
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge returnEdge = (ReturnStatementEdge)cfaEdge;
                successor = this.handleExitFromFunction(explicitElement, returnEdge.getExpression(), returnEdge);
                if (successor != null) break;
                throw new RuntimeException();
            }
            case DeclarationEdge: {
                DeclarationEdge declarationEdge = (DeclarationEdge)cfaEdge;
                successor = this.handleDeclaration(explicitElement, declarationEdge);
                if (successor != null) break;
                throw new RuntimeException();
            }
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                successor = this.handleAssumption(explicitElement, assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption());
                if (successor != null) break;
                throw new RuntimeException();
            }
            case BlankEdge: {
                successor = explicitElement.clone();
                if (successor != null) break;
                throw new RuntimeException();
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(explicitElement, functionCallEdge, cfaEdge);
                if (successor != null) break;
                throw new RuntimeException();
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)cfaEdge;
                successor = this.handleFunctionReturn(explicitElement, functionReturnEdge);
                if (successor == null) {
                    throw new RuntimeException();
                }
                InterpreterElement lSuccessor = successor;
                if (lSuccessor.getInputIndex() == explicitElement.getInputIndex()) break;
                throw new RuntimeException();
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        if (InterpreterBottomElement.INSTANCE.equals(successor)) {
            return Collections.emptySet();
        }
        return Collections.singleton(successor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InterpreterElement handleFunctionReturn(InterpreterElement element, FunctionReturnEdge functionReturnEdge) throws UnrecognizedCCodeException, AccessToUninitializedVariableException {
        CallToReturnEdge summaryEdge = functionReturnEdge.getSuccessor().getEnteringSummaryEdge();
        IASTFunctionCall exprOnSummary = summaryEdge.getExpression();
        InterpreterElement newElement = element.getUpdatedPreviousElement();
        String callerFunctionName = functionReturnEdge.getSuccessor().getFunctionName();
        String calledFunctionName = functionReturnEdge.getPredecessor().getFunctionName();
        if (exprOnSummary instanceof IASTFunctionCallAssignmentStatement) {
            IASTFunctionCallAssignmentStatement binExp = (IASTFunctionCallAssignmentStatement)exprOnSummary;
            IASTExpression op1 = binExp.getLeftHandSide();
            if (!(op1 instanceof IASTIdExpression) && !(op1 instanceof IASTFieldReference)) throw new UnrecognizedCCodeException("on function return", summaryEdge, op1);
            String varName = op1.toASTString();
            String returnVarName = calledFunctionName + "::" + "___cpa_temp_result_var_";
            for (String globalVar : this.globalVars) {
                if (globalVar.equals(varName)) {
                    if (element.contains(returnVarName)) {
                        newElement.assignConstant(varName, element.getValueFor(returnVarName));
                        continue;
                    }
                    System.out.println("FORGETTING: " + exprOnSummary);
                    newElement.forget(varName);
                    continue;
                }
                if (element.contains(globalVar)) {
                    newElement.assignConstant(globalVar, element.getValueFor(globalVar));
                    continue;
                }
                System.out.println("FORGETTING: " + exprOnSummary);
                newElement.forget(varName);
            }
            if (this.globalVars.contains(varName)) return newElement;
            String assignedVarName = this.getvarName(varName, callerFunctionName);
            if (element.contains(returnVarName)) {
                newElement.assignConstant(assignedVarName, element.getValueFor(returnVarName));
                return newElement;
            } else {
                System.out.println("FORGETTING: " + exprOnSummary);
                newElement.forget(assignedVarName);
            }
            return newElement;
        } else {
            if (!(exprOnSummary instanceof IASTFunctionCallStatement)) throw new UnrecognizedCCodeException("on function return", summaryEdge, exprOnSummary.asStatement());
            for (String globalVar : this.globalVars) {
                if (element.contains(globalVar)) {
                    newElement.assignConstant(globalVar, element.getValueFor(globalVar));
                    continue;
                }
                newElement.forget(globalVar);
            }
        }
        return newElement;
    }

    private InterpreterElement handleFunctionCall(InterpreterElement element, FunctionCallEdge callEdge, CFAEdge edge) throws UnrecognizedCCodeException, AccessToUninitializedVariableException {
        FunctionDefinitionNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<IASTExpression> arguments = callEdge.getArguments();
        assert (paramNames.size() == arguments.size());
        InterpreterElement newElement = new InterpreterElement(element, element.getInputIndex(), element.getInputs());
        for (String globalVar : this.globalVars) {
            if (!element.contains(globalVar)) continue;
            newElement.getConstantsMap().put(globalVar, element.getValueFor(globalVar));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            IASTExpression arg = arguments.get(i);
            if (arg instanceof IASTCastExpression) {
                arg = ((IASTCastExpression)arg).getOperand();
            }
            String nameOfParam = paramNames.get(i);
            String formalParamName = this.getvarName(nameOfParam, calledFunctionName);
            if (arg instanceof IASTIdExpression) {
                IASTIdExpression idExp = (IASTIdExpression)arg;
                String nameOfArg = idExp.getName();
                String actualParamName = this.getvarName(nameOfArg, callerFunctionName);
                if (!element.contains(actualParamName)) continue;
                newElement.assignConstant(formalParamName, element.getValueFor(actualParamName));
                continue;
            }
            if (arg instanceof IASTLiteralExpression) {
                Long val = this.parseLiteral((IASTLiteralExpression)arg, edge);
                if (val != null) {
                    newElement.assignConstant(formalParamName, val);
                    continue;
                }
                newElement.forget(formalParamName);
                continue;
            }
            if (arg instanceof IASTTypeIdExpression) {
                newElement.forget(formalParamName);
                continue;
            }
            if (arg instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExp = (IASTUnaryExpression)arg;
                assert (unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.STAR || unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.AMPER);
                continue;
            }
            if (arg instanceof IASTFieldReference) {
                newElement.forget(formalParamName);
                continue;
            }
            newElement.forget(formalParamName);
        }
        return newElement;
    }

    private InterpreterElement handleExitFromFunction(InterpreterElement element, IASTExpression expression, ReturnStatementEdge returnEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        InterpreterElement lSuccessor = this.handleAssignmentToVariable(element, "___cpa_temp_result_var_", expression, returnEdge);
        if (lSuccessor == null) {
            throw new RuntimeException();
        }
        return lSuccessor;
    }

    private AbstractElement handleAssumption(InterpreterElement element, IASTExpression expression, CFAEdge cfaEdge, boolean truthValue) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        if (expression instanceof IASTBinaryExpression) {
            IASTExpression op2;
            IASTExpression op1;
            IASTBinaryExpression binExp = (IASTBinaryExpression)expression;
            IASTBinaryExpression.BinaryOperator opType = binExp.getOperator();
            AbstractElement lSuccessor = this.propagateBooleanExpression(element, opType, op1 = binExp.getOperand1(), op2 = binExp.getOperand2(), functionName, truthValue, cfaEdge);
            if (lSuccessor == null) {
                throw new RuntimeException();
            }
            return lSuccessor;
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExp = (IASTUnaryExpression)expression;
            if (unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.NOT) {
                IASTExpression exp1 = unaryExp.getOperand();
                AbstractElement lSuccessor = this.handleAssumption(element, exp1, cfaEdge, !truthValue);
                if (lSuccessor == null) {
                    throw new RuntimeException();
                }
                return lSuccessor;
            }
            throw new UnrecognizedCCodeException("Unknown unary operator in assumption", cfaEdge, expression);
        }
        if (expression instanceof IASTCastExpression) {
            AbstractElement lSuccessor = this.handleAssumption(element, ((IASTCastExpression)expression).getOperand(), cfaEdge, truthValue);
            if (lSuccessor == null) {
                throw new RuntimeException();
            }
            return lSuccessor;
        }
        if (expression instanceof IASTIdExpression || expression instanceof IASTFieldReference) {
            AbstractElement lSuccessor = this.propagateBooleanExpression(element, null, expression, null, functionName, truthValue, cfaEdge);
            if (lSuccessor == null) {
                throw new RuntimeException();
            }
            return lSuccessor;
        }
        throw new UnrecognizedCCodeException("Unknown expression type in assumption", cfaEdge, expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractElement propagateBooleanExpression(AbstractElement element, IASTBinaryExpression.BinaryOperator opType, IASTExpression op1, IASTExpression op2, String functionName, boolean truthValue, CFAEdge edge) throws UnrecognizedCCodeException, AccessToUninitializedVariableException {
        InterpreterElement newElement = ((InterpreterElement)element).clone();
        if (op1 instanceof IASTIdExpression || op1 instanceof IASTFieldReference || op1 instanceof IASTArraySubscriptExpression) {
            if (op2 == null && opType == null) {
                String lVariableName = op1.toASTString();
                String lScopedVariableName = this.getvarName(lVariableName, functionName);
                if (!(truthValue ? newElement.getValueFor(lScopedVariableName) == 0L : newElement.getValueFor(lScopedVariableName) != 0L)) return newElement;
                return InterpreterBottomElement.INSTANCE;
            }
            if (op2 instanceof IASTLiteralExpression) {
                String varName = op1.toASTString();
                if (!(op2 instanceof IASTIntegerLiteralExpression)) throw new UnrecognizedCCodeException("Unhandled case", edge);
                int valueOfLiteral = ((IASTIntegerLiteralExpression)op2).getValue().intValue();
                if (opType == IASTBinaryExpression.BinaryOperator.EQUALS) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) == (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.NOT_EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) != (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) > (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.LESS_EQUAL, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) >= (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.LESS_THAN, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) < (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.GREATER_EQUAL, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.LESS_EQUAL) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) <= (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.GREATER_THAN, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.MINUS) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(varName, functionName)) != (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.PLUS) {
                    if (!(truthValue ? newElement.getValueFor(this.getvarName(varName, functionName)) == (long)(0 - valueOfLiteral) : newElement.getValueFor(this.getvarName(varName, functionName)) != (long)(0 - valueOfLiteral))) return newElement;
                    return InterpreterBottomElement.INSTANCE;
                }
                if (opType != IASTBinaryExpression.BinaryOperator.BINARY_AND && opType != IASTBinaryExpression.BinaryOperator.BINARY_OR && opType != IASTBinaryExpression.BinaryOperator.BINARY_XOR) throw new UnrecognizedCCodeException("Unhandled case", edge);
                throw new RuntimeException();
            }
            if (op2 instanceof IASTIdExpression || op2 instanceof IASTUnaryExpression && (((IASTUnaryExpression)op2).getOperator() == IASTUnaryExpression.UnaryOperator.AMPER || ((IASTUnaryExpression)op2).getOperator() == IASTUnaryExpression.UnaryOperator.STAR)) {
                String leftVarName = op1.toASTString();
                String rightVarName = op2.toASTString();
                if (opType == IASTBinaryExpression.BinaryOperator.EQUALS) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(rightVarName, functionName)) == newElement.getValueFor(this.getvarName(leftVarName, functionName))) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.NOT_EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(rightVarName, functionName)) != newElement.getValueFor(this.getvarName(leftVarName, functionName))) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(leftVarName, functionName)) > newElement.getValueFor(this.getvarName(rightVarName, functionName))) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.LESS_EQUAL, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(leftVarName, functionName)) >= newElement.getValueFor(this.getvarName(rightVarName, functionName))) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.LESS_THAN, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
                    if (truthValue) {
                        if (newElement.getValueFor(this.getvarName(leftVarName, functionName)) < newElement.getValueFor(this.getvarName(rightVarName, functionName))) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.GREATER_EQUAL, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType != IASTBinaryExpression.BinaryOperator.LESS_EQUAL) throw new UnrecognizedCCodeException("Unhandled case", edge);
                if (truthValue) {
                    if (newElement.getValueFor(this.getvarName(leftVarName, functionName)) <= newElement.getValueFor(this.getvarName(rightVarName, functionName))) return newElement;
                    return InterpreterBottomElement.INSTANCE;
                }
                AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.GREATER_THAN, op1, op2, functionName, !truthValue, edge);
                if (lSuccessor != null) return lSuccessor;
                throw new RuntimeException();
            }
            if (op2 instanceof IASTUnaryExpression) {
                String varName = op1.toASTString();
                IASTUnaryExpression unaryExp = (IASTUnaryExpression)op2;
                IASTExpression unaryExpOp = unaryExp.getOperand();
                IASTUnaryExpression.UnaryOperator operatorType = unaryExp.getOperator();
                if (operatorType != IASTUnaryExpression.UnaryOperator.MINUS) throw new UnrecognizedCCodeException("Unhandled case", edge);
                if (!(unaryExpOp instanceof IASTLiteralExpression)) throw new UnrecognizedCCodeException("Unhandled case", edge);
                IASTLiteralExpression literalExp = (IASTLiteralExpression)unaryExpOp;
                if (!(literalExp instanceof IASTIntegerLiteralExpression)) throw new UnrecognizedCCodeException("Unhandled case", edge);
                int valueOfLiteral = ((IASTIntegerLiteralExpression)literalExp).getValue().intValue();
                if (opType == IASTBinaryExpression.BinaryOperator.EQUALS) {
                    if (truthValue) {
                        String lVariableName = this.getvarName(varName, functionName);
                        if (newElement.contains(lVariableName)) {
                            if (newElement.getValueFor(lVariableName) == (long)valueOfLiteral) return newElement;
                            return InterpreterBottomElement.INSTANCE;
                        }
                        newElement.assignConstant(this.getvarName(varName, functionName), valueOfLiteral);
                        throw new RuntimeException();
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.NOT_EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    if (truthValue) {
                        String lVariableName = this.getvarName(varName, functionName);
                        if (!newElement.contains(lVariableName) || newElement.getValueFor(lVariableName) != (long)valueOfLiteral) return newElement;
                        return InterpreterBottomElement.INSTANCE;
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
                    if (truthValue) {
                        if (!newElement.contains(this.getvarName(varName, functionName)) || newElement.getValueFor(this.getvarName(varName, functionName)) > (long)valueOfLiteral) return newElement;
                        throw new RuntimeException();
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.LESS_EQUAL, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                    if (truthValue) {
                        if (!newElement.contains(this.getvarName(varName, functionName)) || newElement.getValueFor(this.getvarName(varName, functionName)) >= (long)valueOfLiteral) return newElement;
                        throw new RuntimeException();
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.LESS_THAN, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
                    if (truthValue) {
                        if (!newElement.contains(this.getvarName(varName, functionName)) || newElement.getValueFor(this.getvarName(varName, functionName)) < (long)valueOfLiteral) return newElement;
                        throw new RuntimeException();
                    }
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.GREATER_EQUAL, op1, op2, functionName, !truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                if (opType != IASTBinaryExpression.BinaryOperator.LESS_EQUAL) throw new UnrecognizedCCodeException("Unhandled case", edge);
                if (truthValue) {
                    if (!newElement.contains(this.getvarName(varName, functionName)) || newElement.getValueFor(this.getvarName(varName, functionName)) <= (long)valueOfLiteral) return newElement;
                    throw new RuntimeException();
                }
                AbstractElement lSuccessor = this.propagateBooleanExpression(element, IASTBinaryExpression.BinaryOperator.GREATER_THAN, op1, op2, functionName, !truthValue, edge);
                if (lSuccessor != null) return lSuccessor;
                throw new RuntimeException();
            }
            if (op2 instanceof IASTBinaryExpression) {
                String varName = op1.toASTString();
                newElement.forget(varName);
                return newElement;
            } else {
                if (op2 instanceof IASTCastExpression) {
                    IASTCastExpression castExp = (IASTCastExpression)op2;
                    IASTExpression exprInCastOp = castExp.getOperand();
                    AbstractElement lSuccessor = this.propagateBooleanExpression(element, opType, op1, exprInCastOp, functionName, truthValue, edge);
                    if (lSuccessor != null) return lSuccessor;
                    throw new RuntimeException();
                }
                String varName = op1.toASTString();
                newElement.forget(varName);
            }
            return newElement;
        } else {
            if (op1 instanceof IASTCastExpression) {
                IASTCastExpression castExp = (IASTCastExpression)op1;
                IASTExpression castOperand = castExp.getOperand();
                AbstractElement lSuccessor = this.propagateBooleanExpression(element, opType, castOperand, op2, functionName, truthValue, edge);
                if (lSuccessor != null) return lSuccessor;
                throw new RuntimeException();
            }
            String varName = op1.toASTString();
            newElement.forget(varName);
        }
        return newElement;
    }

    private InterpreterElement handleDeclaration(InterpreterElement element, DeclarationEdge declarationEdge) {
        InterpreterElement newElement = element.clone();
        if (declarationEdge.getDeclaration() instanceof IASTVariableDeclaration) {
            IASTVariableDeclaration decl = (IASTVariableDeclaration)declarationEdge.getDeclaration();
            String varName = decl.getName();
            if (decl.getDeclSpecifier() instanceof IASTPointerTypeSpecifier) {
                return newElement;
            }
            if (decl.isGlobal()) {
                this.globalVars.add(varName);
                newElement.assignConstant(varName, 0L);
            }
        }
        return newElement;
    }

    private InterpreterElement handleStatement(InterpreterElement element, IASTStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, AccessToUninitializedVariableException, MissingInputException {
        if (expression instanceof IASTAssignment) {
            return this.handleAssignment(element, (IASTAssignment)((Object)expression), cfaEdge);
        }
        if (expression instanceof IASTFunctionCallStatement) {
            return element.clone();
        }
        if (expression instanceof IASTExpressionStatement) {
            return element.clone();
        }
        throw new UnrecognizedCCodeException(cfaEdge, expression);
    }

    private InterpreterElement handleAssignment(InterpreterElement element, IASTAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        IASTExpression op1 = assignExpression.getLeftHandSide();
        IASTRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof IASTIdExpression) {
            return this.handleAssignmentToVariable(element, ((IASTIdExpression)op1).getName(), op2, cfaEdge);
        }
        throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
    }

    private InterpreterElement handleAssignmentToVariable(InterpreterElement element, String lParam, IASTRightHandSide rightExp, CFAEdge cfaEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        if (rightExp == null || rightExp instanceof IASTLiteralExpression) {
            return this.handleAssignmentOfLiteral(element, lParam, (IASTLiteralExpression)rightExp, functionName, cfaEdge);
        }
        if (rightExp instanceof IASTIdExpression) {
            return this.handleAssignmentOfVariable(element, lParam, (IASTIdExpression)rightExp, functionName);
        }
        if (rightExp instanceof IASTCastExpression) {
            return this.handleAssignmentOfCast(element, lParam, (IASTCastExpression)rightExp, cfaEdge);
        }
        if (rightExp instanceof IASTUnaryExpression) {
            return this.handleAssignmentOfUnaryExp(element, lParam, (IASTUnaryExpression)rightExp, cfaEdge);
        }
        if (rightExp instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)rightExp;
            InterpreterElement lSuccessor = this.handleAssignmentOfBinaryExp(element, lParam, binExp.getOperand1(), binExp.getOperand2(), binExp.getOperator(), cfaEdge);
            if (lSuccessor == null) {
                throw new RuntimeException();
            }
            return lSuccessor;
        }
        throw new UnrecognizedCCodeException(cfaEdge, rightExp);
    }

    private InterpreterElement handleAssignmentOfCast(InterpreterElement element, String lParam, IASTCastExpression castExp, CFAEdge cfaEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        IASTExpression castOperand = castExp.getOperand();
        InterpreterElement lSuccessor = this.handleAssignmentToVariable(element, lParam, castOperand, cfaEdge);
        if (lSuccessor == null) {
            throw new RuntimeException();
        }
        return lSuccessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InterpreterElement handleAssignmentOfUnaryExp(InterpreterElement element, String lParam, IASTUnaryExpression unaryExp, CFAEdge cfaEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        String assignedVar = this.getvarName(lParam, functionName);
        InterpreterElement newElement = element.clone();
        IASTExpression unaryOperand = unaryExp.getOperand();
        IASTUnaryExpression.UnaryOperator unaryOperator = unaryExp.getOperator();
        if (unaryOperator == IASTUnaryExpression.UnaryOperator.STAR) {
            newElement.forget(assignedVar);
            if (unaryOperand instanceof IASTCastExpression) {
                unaryOperand = ((IASTCastExpression)unaryOperand).getOperand();
            }
            if (!(unaryOperand instanceof IASTIdExpression)) throw new UnrecognizedCCodeException(cfaEdge, unaryOperand);
            this.missingInformationLeftVariable = assignedVar;
            this.missingInformationRightPointer = ((IASTIdExpression)unaryOperand).getName();
            return newElement;
        } else {
            Long value = this.getExpressionValue(element, unaryExp, functionName, cfaEdge);
            if (value != null) {
                newElement.assignConstant(assignedVar, value);
                return newElement;
            } else {
                System.out.println("FORGETTING: " + unaryExp.toASTString());
                newElement.forget(assignedVar);
            }
        }
        return newElement;
    }

    private InterpreterElement handleAssignmentOfBinaryExp(InterpreterElement element, String lParam, IASTExpression lVarInBinaryExp, IASTExpression rVarInBinaryExp, IASTBinaryExpression.BinaryOperator binaryOperator, CFAEdge cfaEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        String assignedVar = this.getvarName(lParam, functionName);
        InterpreterElement newElement = element.clone();
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case EQUALS: 
            case NOT_EQUALS: 
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: 
            case DIVIDE: 
            case MODULO: 
            case BINARY_AND: 
            case BINARY_OR: {
                if (lVarInBinaryExp instanceof IASTUnaryExpression && ((IASTUnaryExpression)lVarInBinaryExp).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                    Object val1 = null;
                    throw new RuntimeException();
                }
                Long val1 = this.getExpressionValue(element, lVarInBinaryExp, functionName, cfaEdge);
                Long val2 = val1 != null ? this.getExpressionValue(element, rVarInBinaryExp, functionName, cfaEdge) : null;
                if (val2 != null) {
                    long value;
                    long lValue1 = val1;
                    long lValue2 = val2;
                    switch (binaryOperator) {
                        case PLUS: {
                            value = lValue1 + lValue2;
                            break;
                        }
                        case MINUS: {
                            value = lValue1 - lValue2;
                            break;
                        }
                        case MULTIPLY: {
                            value = lValue1 * lValue2;
                            break;
                        }
                        case GREATER_THAN: {
                            value = lValue1 > lValue2 ? 1L : 0L;
                            break;
                        }
                        case GREATER_EQUAL: {
                            value = lValue1 >= lValue2 ? 1L : 0L;
                            break;
                        }
                        case LESS_THAN: {
                            value = lValue1 < lValue2 ? 1L : 0L;
                            break;
                        }
                        case LESS_EQUAL: {
                            value = lValue1 <= lValue2 ? 1L : 0L;
                            break;
                        }
                        case EQUALS: {
                            value = lValue1 == lValue2 ? 1L : 0L;
                            break;
                        }
                        case NOT_EQUALS: {
                            value = lValue1 != lValue2 ? 1L : 0L;
                            break;
                        }
                        case SHIFT_RIGHT: {
                            value = lValue1 >> (int)lValue2;
                            break;
                        }
                        case SHIFT_LEFT: {
                            value = lValue1 << (int)lValue2;
                            break;
                        }
                        case DIVIDE: {
                            value = lValue1 / lValue2;
                            break;
                        }
                        case MODULO: {
                            value = lValue1 % lValue2;
                            break;
                        }
                        case BINARY_AND: {
                            value = lValue1 & lValue2;
                            break;
                        }
                        case BINARY_OR: {
                            value = lValue1 | lValue2;
                            break;
                        }
                        default: {
                            throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                        }
                    }
                    newElement.assignConstant(assignedVar, value);
                    break;
                }
                throw new RuntimeException();
            }
            default: {
                throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
            }
        }
        return newElement;
    }

    private Long getExpressionValue(InterpreterElement element, IASTExpression expression, String functionName, CFAEdge cfaEdge) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        if (expression instanceof IASTLiteralExpression) {
            return this.parseLiteral((IASTLiteralExpression)expression, cfaEdge);
        }
        if (expression instanceof IASTIdExpression) {
            String varName = this.getvarName(((IASTIdExpression)expression).getName(), functionName);
            return element.getValueFor(varName);
        }
        if (expression instanceof IASTCastExpression) {
            return this.getExpressionValue(element, ((IASTCastExpression)expression).getOperand(), functionName, cfaEdge);
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            IASTUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            IASTExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case MINUS: {
                    Long val = this.getExpressionValue(element, unaryOperand, functionName, cfaEdge);
                    return val != null ? Long.valueOf(-val.longValue()) : null;
                }
                case AMPER: {
                    return null;
                }
            }
            throw new UnrecognizedCCodeException("unknown unary operator", cfaEdge, unaryExpression);
        }
        throw new UnrecognizedCCodeException(cfaEdge, expression);
    }

    private InterpreterElement handleAssignmentOfVariable(InterpreterElement element, String lParam, IASTExpression op2, String functionName) throws MissingInputException, AccessToUninitializedVariableException {
        String rParam = op2.toASTString();
        String leftVarName = this.getvarName(lParam, functionName);
        String rightVarName = this.getvarName(rParam, functionName);
        InterpreterElement newElement = element.clone();
        newElement.assignConstant(leftVarName, newElement.getValueFor(rightVarName));
        return newElement;
    }

    private InterpreterElement handleAssignmentOfLiteral(InterpreterElement element, String lParam, IASTLiteralExpression op2, String functionName, CFAEdge edge) throws UnrecognizedCCodeException {
        InterpreterElement newElement = element.clone();
        Long val = op2 == null ? 0L : this.parseLiteral(op2, edge);
        String assignedVar = this.getvarName(lParam, functionName);
        if (val != null) {
            newElement.assignConstant(assignedVar, val);
        } else {
            newElement.forget(assignedVar);
        }
        return newElement;
    }

    private Long parseLiteral(IASTLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTIntegerLiteralExpression) {
            return ((IASTIntegerLiteralExpression)expression).asLong();
        }
        if (expression instanceof IASTFloatLiteralExpression) {
            return null;
        }
        if (expression instanceof IASTCharLiteralExpression) {
            return ((IASTCharLiteralExpression)expression).getCharacter();
        }
        if (expression instanceof IASTStringLiteralExpression) {
            return null;
        }
        throw new UnrecognizedCCodeException("unknown literal", edge, expression);
    }

    public String getvarName(String variableName, String functionName) {
        if (this.globalVars.contains(variableName)) {
            return variableName;
        }
        return functionName + "::" + variableName;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> elements, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        assert (element instanceof InterpreterElement);
        InterpreterElement explicitElement = (InterpreterElement)element;
        for (AbstractElement ae : elements) {
            if (ae instanceof PointerElement) {
                return this.strengthen(explicitElement, (PointerElement)ae, cfaEdge, precision);
            }
            if (ae instanceof ConstrainedAssumeElement) {
                return this.strengthen(cfaEdge.getSuccessor(), explicitElement, (ConstrainedAssumeElement)ae, precision);
            }
            if (!(ae instanceof GuardedEdgeAutomatonPredicateElement)) continue;
            return this.strengthen(cfaEdge.getSuccessor(), explicitElement, (GuardedEdgeAutomatonPredicateElement)ae, precision);
        }
        return null;
    }

    private Collection<? extends AbstractElement> strengthen(InterpreterElement explicitElement, PointerElement pointerElement, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException, MissingInputException, AccessToUninitializedVariableException {
        ArrayList<InterpreterElement> retList = new ArrayList<InterpreterElement>();
        if (this.missingInformationLeftVariable != null && this.missingInformationRightPointer != null) {
            String rightVar = this.derefPointerToVariable(pointerElement, this.missingInformationRightPointer);
            if (rightVar != null && explicitElement.contains(rightVar = this.getvarName(rightVar, cfaEdge.getPredecessor().getFunctionName()))) {
                explicitElement.assignConstant(this.missingInformationLeftVariable, explicitElement.getValueFor(rightVar));
            }
            this.missingInformationLeftVariable = null;
            this.missingInformationRightPointer = null;
        } else if (this.missingInformationLeftPointer != null && this.missingInformationRightExpression != null) {
            String leftVar = this.derefPointerToVariable(pointerElement, this.missingInformationLeftPointer);
            if (leftVar != null) {
                leftVar = this.getvarName(leftVar, cfaEdge.getPredecessor().getFunctionName());
                retList.add(this.handleAssignmentToVariable(explicitElement, leftVar, this.missingInformationRightExpression, cfaEdge));
                return retList;
            }
            this.missingInformationLeftPointer = null;
            this.missingInformationRightExpression = null;
        }
        return null;
    }

    private String derefPointerToVariable(PointerElement pointerElement, String pointer) {
        Pointer p = pointerElement.lookupPointer(pointer);
        if (p != null && p.getNumberOfTargets() == 1) {
            Memory.PointerTarget target = p.getFirstTarget();
            if (target instanceof Memory.Variable) {
                return ((Memory.Variable)target).getVarName();
            }
            if (target instanceof Memory.StackArrayCell) {
                return ((Memory.StackArrayCell)target).getVarName();
            }
        }
        return null;
    }

    public Collection<? extends AbstractElement> strengthen(CFANode pNode, InterpreterElement pElement, GuardedEdgeAutomatonPredicateElement pAutomatonElement, Precision pPrecision) {
        AbstractElement lResultElement = pElement;
        Iterator<ECPPredicate> i$ = pAutomatonElement.iterator();
        if (i$.hasNext()) {
            ECPPredicate lPredicate = i$.next();
            AssumeEdge lEdge = ToFlleShAssumeEdgeTranslator.translate(pNode, lPredicate);
            try {
                Collection<? extends AbstractElement> lResult = this.getAbstractSuccessors(lResultElement, pPrecision, lEdge);
                if (lResult.size() == 0) {
                    return Collections.emptySet();
                }
                if (lResult.size() != 1) {
                    throw new RuntimeException();
                }
                lResultElement = lResult.iterator().next();
                return lResult;
            }
            catch (CPATransferException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.singleton(lResultElement);
    }

    public Collection<? extends AbstractElement> strengthen(CFANode pNode, InterpreterElement pElement, ConstrainedAssumeElement pAssumeElement, Precision pPrecision) {
        AssumeEdge lEdge = new AssumeEdge(pAssumeElement.getExpression().toASTString(), pNode.getLineNumber(), pNode, pNode, pAssumeElement.getExpression(), true);
        try {
            Collection<? extends AbstractElement> lResult = this.getAbstractSuccessors(pElement, pPrecision, lEdge);
            return lResult;
        }
        catch (CPATransferException e) {
            throw new RuntimeException(e);
        }
    }
}

