/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import java.util.Arrays;
import java.util.Collections;

public class Interval {
    protected Long low;
    protected Long high;
    public static final Interval FALSE = new Interval(0L, 0L);
    public static final Interval EMPTY = Interval.createEmptyInterval();

    private Interval() {
    }

    public Interval(Long value) {
        this.low = value;
        this.high = value;
        this.isSane();
    }

    public Interval(Long low, Long high) {
        this.low = low;
        this.high = high;
        this.isSane();
    }

    private boolean isSane() {
        if (this.low > this.high) {
            throw new IllegalStateException("low cannot be larger than high");
        }
        return true;
    }

    public Long getLow() {
        return this.low;
    }

    public Long getHigh() {
        return this.high;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            Interval another = (Interval)other;
            if (this.isEmpty() && another.isEmpty()) {
                return true;
            }
            if (this.isEmpty() || another.isEmpty()) {
                return false;
            }
            return this.low.equals(another.low) && this.high.equals(another.high);
        }
        return false;
    }

    public boolean isSingular() {
        return this.low.equals(this.high);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int result = 17;
        result = 31 * result + this.low.hashCode();
        result = 31 * result + this.high.hashCode();
        return result;
    }

    public Interval clone() {
        return new Interval(this.low, this.high);
    }

    public Interval union(Interval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return Interval.createEmptyInterval();
        }
        return new Interval(Math.min(this.low, other.low), Math.max(this.high, other.high));
    }

    public Interval intersect(Interval other) {
        Interval interval = null;
        interval = this.intersects(other) ? new Interval(Math.max(this.low, other.low), Math.min(this.high, other.high)) : Interval.createEmptyInterval();
        return interval;
    }

    public boolean isLessThan(Interval other) {
        return !this.isEmpty() && !other.isEmpty() && this.high < other.low;
    }

    public boolean isGreaterThan(Interval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low > other.high;
    }

    public boolean mayBeLessThan(Interval other) {
        return this.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.low < other.high;
    }

    public boolean mayBeLessOrEqualThan(Interval other) {
        return this.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.low <= other.high;
    }

    public boolean mayBeGreaterThan(Interval other) {
        return other.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.high > other.low;
    }

    public boolean mayBeGreaterOrEqualThan(Interval other) {
        return other.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.high >= other.low;
    }

    public boolean isFalse() {
        return this.equals(FALSE);
    }

    public boolean isTrue() {
        return !this.isEmpty() && (this.high < 0L || this.low > 0L);
    }

    public Interval minimum(Interval other) {
        Interval interval = new Interval(Math.min(this.low, other.low), Math.min(this.high, other.high));
        return interval;
    }

    public Interval maximum(Interval other) {
        Interval interval = new Interval(Math.max(this.low, other.low), Math.max(this.high, other.high));
        return interval;
    }

    public Interval limitLowerBoundBy(Interval other) {
        Interval interval = null;
        interval = this.isEmpty() || other.isEmpty() || this.high < other.low ? Interval.createEmptyInterval() : new Interval(Math.max(this.low, other.low), this.high);
        return interval;
    }

    public Interval limitUpperBoundBy(Interval other) {
        Interval interval = null;
        interval = this.isEmpty() || other.isEmpty() || this.low > other.high ? Interval.createEmptyInterval() : new Interval(this.low, Math.min(this.high, other.high));
        return interval;
    }

    public boolean intersects(Interval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.low >= other.low && this.low <= other.high || this.high >= other.low && this.high <= other.high || this.low <= other.low && this.high >= other.high;
    }

    public boolean contains(Interval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low <= other.low && other.high <= this.high;
    }

    public Interval plus(Interval interval) {
        if (this.isEmpty() || interval.isEmpty()) {
            return Interval.createEmptyInterval();
        }
        return new Interval(Interval.scalarPlus(this.low, interval.low), Interval.scalarPlus(this.high, interval.high));
    }

    public Interval plus(Long offset) {
        return this.plus(new Interval(offset, offset));
    }

    public Interval minus(Interval other) {
        return this.plus(other.negate());
    }

    public Interval minus(Long offset) {
        return this.plus(-offset.longValue());
    }

    public Interval times(Interval other) {
        Long[] values = new Long[]{Interval.scalarTimes(this.low, other.low), Interval.scalarTimes(this.low, other.high), Interval.scalarTimes(this.high, other.low), Interval.scalarTimes(this.high, other.high)};
        return new Interval(Collections.min(Arrays.asList(values)), Collections.max(Arrays.asList(values)));
    }

    public Interval divide(Interval other) {
        if (other.contains(FALSE)) {
            return Interval.createUnboundInterval();
        }
        Long[] values = new Long[]{this.low / other.low, this.low / other.high, this.high / other.low, this.high / other.high};
        return new Interval(Collections.min(Arrays.asList(values)), Collections.max(Arrays.asList(values)));
    }

    public Interval shiftLeft(Interval offset) {
        if (offset.mayBeLessThan(FALSE)) {
            return Interval.createUnboundInterval();
        }
        Long newLow = this.low << (int)(this.low < 0L ? offset.high : offset.low).longValue();
        Long newHigh = this.high << (int)(this.high < 0L ? offset.low : offset.high).longValue();
        if (this.low < 0L && newLow > this.low || this.high > 0L && newHigh < this.high) {
            return Interval.createUnboundInterval();
        }
        return new Interval(newLow, newHigh);
    }

    public Interval shiftRight(Interval offset) {
        if (offset.mayBeLessThan(FALSE)) {
            return Interval.createUnboundInterval();
        }
        Long newLow = this.low >> (int)(this.low < 0L ? offset.low : offset.high).longValue();
        Long newHigh = this.high >> (int)(this.high < 0L ? offset.high : offset.low).longValue();
        return new Interval(newLow, newHigh);
    }

    public Interval negate() {
        return new Interval(Interval.scalarTimes(this.high, -1L), Interval.scalarTimes(this.low, -1L));
    }

    public boolean isEmpty() {
        return this.low == null && this.high == null;
    }

    public String toString() {
        return "[" + this.low + "; " + this.high + "]";
    }

    private static Interval createEmptyInterval() {
        return new Interval();
    }

    public static Interval createUnboundInterval() {
        return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static Interval createLowerBoundedInterval(Long lowerBound) {
        return new Interval(lowerBound, Long.MAX_VALUE);
    }

    public static Interval createUpperBoundedInterval(Long upperBound) {
        return new Interval(Long.MIN_VALUE, upperBound);
    }

    public static Interval createFalseInterval() {
        return new Interval(0L);
    }

    public static Interval createTrueInterval() {
        return new Interval(1L);
    }

    private static Long scalarPlus(Long x, Long y) {
        Long result = x + y;
        if (Long.signum(x) + Long.signum(y) == 2 && Long.signum(result) == -1) {
            result = Long.MAX_VALUE;
        } else if (Long.signum(x) + Long.signum(y) == -2 && Long.signum(result) == 1) {
            result = Long.MIN_VALUE;
        }
        return result;
    }

    private static Long scalarTimes(Long x, Long y) {
        Long bound = Long.signum(x) == Long.signum(y) ? Long.MAX_VALUE : Long.MIN_VALUE;
        if (x != 0L && (y > 0L && y > bound / x || y < 0L && y < bound / x)) {
            return bound;
        }
        return x * y;
    }
}

