/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisDomain;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisElement;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisTransferRelation;

@Options(prefix="cpa.interval")
public class IntervalAnalysisCPA
implements ConfigurableProgramAnalysis {
    @Option(name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which type of merge operator to use for IntervalAnalysisCPA")
    private String mergeType = "SEP";
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private TransferRelation transferRelation;
    private PrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(IntervalAnalysisCPA.class);
    }

    private IntervalAnalysisCPA(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.abstractDomain = new IntervalAnalysisDomain();
        this.mergeOperator = this.mergeType.equals("SEP") ? MergeSepOperator.getInstance() : new MergeJoinOperator(this.abstractDomain);
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = new IntervalAnalysisTransferRelation(config);
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        return new IntervalAnalysisElement();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }
}

