/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.interval.Interval;

public class IntervalAnalysisElement
implements AbstractElement {
    private Map<String, Interval> intervals;
    private Map<String, Integer> referenceCounts;
    private final IntervalAnalysisElement previousElement;

    public IntervalAnalysisElement() {
        this(new HashMap<String, Interval>(), new HashMap<String, Integer>(), null);
    }

    public IntervalAnalysisElement(IntervalAnalysisElement previousElement) {
        this(new HashMap<String, Interval>(), new HashMap<String, Integer>(), previousElement);
    }

    public IntervalAnalysisElement(Map<String, Interval> intervals, Map<String, Integer> referencesMap, IntervalAnalysisElement previousElement) {
        this.intervals = intervals;
        this.referenceCounts = referencesMap;
        this.previousElement = previousElement;
    }

    public Interval getInterval(String variableName) {
        return this.intervals.get(variableName);
    }

    private Integer getReferenceCount(String variableName) {
        return this.referenceCounts.containsKey(variableName) ? this.referenceCounts.get(variableName) : 0;
    }

    @Deprecated
    public boolean exceedsThreshold(String variableName, Integer threshold) {
        Integer referenceCount = this.referenceCounts.containsKey(variableName) ? this.referenceCounts.get(variableName) : 0;
        return referenceCount > threshold;
    }

    public IntervalAnalysisElement getPreviousElement() {
        return this.previousElement;
    }

    public boolean contains(String variableName) {
        return this.intervals.containsKey(variableName);
    }

    public IntervalAnalysisElement addInterval(String variableName, Interval interval, int pThreshold) {
        if (!this.intervals.containsKey(variableName) || !this.intervals.get(variableName).equals(interval)) {
            int referenceCount = this.getReferenceCount(variableName);
            if (referenceCount < pThreshold) {
                this.referenceCounts.put(variableName, referenceCount + 1);
                this.intervals.put(variableName, interval);
            } else {
                this.removeInterval(variableName);
            }
        }
        return this;
    }

    public IntervalAnalysisElement removeInterval(String variableName) {
        if (this.intervals.containsKey(variableName)) {
            this.intervals.remove(variableName);
        }
        return this;
    }

    public IntervalAnalysisElement join(IntervalAnalysisElement reachedElement) {
        HashMap<String, Interval> newIntervals = new HashMap<String, Interval>();
        HashMap<String, Integer> newReferences = new HashMap<String, Integer>();
        newReferences.putAll(this.referenceCounts);
        for (String variableName : reachedElement.intervals.keySet()) {
            if (this.intervals.containsKey(variableName)) {
                newIntervals.put(variableName, this.getInterval(variableName).union(reachedElement.getInterval(variableName)));
                newReferences.put(variableName, Math.max(this.getReferenceCount(variableName), reachedElement.getReferenceCount(variableName)));
                continue;
            }
            newReferences.put(variableName, reachedElement.getReferenceCount(variableName));
        }
        return new IntervalAnalysisElement(newIntervals, newReferences, this.previousElement);
    }

    public boolean isLessOrEqual(IntervalAnalysisElement reachedElement) {
        if (this.intervals.size() < reachedElement.intervals.size()) {
            return false;
        }
        for (String variableName : reachedElement.intervals.keySet()) {
            if (this.intervals.containsKey(variableName) && reachedElement.getInterval(variableName).contains(this.getInterval(variableName))) continue;
            return false;
        }
        return true;
    }

    public IntervalAnalysisElement clone() {
        IntervalAnalysisElement newElement = new IntervalAnalysisElement(this.previousElement);
        for (String variableName : this.intervals.keySet()) {
            newElement.intervals.put(variableName, this.getInterval(variableName).clone());
        }
        for (String variableName : this.referenceCounts.keySet()) {
            newElement.referenceCounts.put(variableName, this.getReferenceCount(variableName));
        }
        return newElement;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        IntervalAnalysisElement otherElement = (IntervalAnalysisElement)other;
        if (this.intervals.size() != otherElement.intervals.size()) {
            return false;
        }
        if (this.previousElement != otherElement.previousElement) {
            return false;
        }
        for (String variableName : this.intervals.keySet()) {
            if (otherElement.intervals.containsKey(variableName) && otherElement.intervals.get(variableName).equals(this.intervals.get(variableName))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.intervals).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (Map.Entry<String, Interval> entry : this.intervals.entrySet()) {
            String key = entry.getKey();
            sb.append(" <");
            sb.append(key);
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append(" :: ");
            sb.append(this.getReferenceCount(key));
            sb.append(">\n");
        }
        return sb.append("] size->  ").append(this.intervals.size()).toString();
    }
}

