/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.NumericTypes;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisElement;
import org.sosy_lab.cpachecker.cpa.pointer.PointerElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

@Options(prefix="cpa.interval")
public class IntervalAnalysisTransferRelation
implements TransferRelation {
    @Option(description="decides whether one (false) or two (true) successors should be created when an inequality-check is encountered")
    private boolean splitIntervals = false;
    private static final String RETURN_VARIABLE_BASE_NAME = "___cpa_temp_result_var_";
    private final Set<String> globalVars = new HashSet<String>();
    @Option(description="at most that many intervals will be tracked per variable")
    private int threshold = 0;

    public IntervalAnalysisTransferRelation(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        Collection<? extends AbstractElement> successors = null;
        IntervalAnalysisElement successor = null;
        IntervalAnalysisElement intervalElement = (IntervalAnalysisElement)element;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)cfaEdge;
                successor = this.handleStatement(intervalElement, statementEdge.getStatement(), cfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge returnEdge = (ReturnStatementEdge)cfaEdge;
                successor = this.handleExitFromFunction(intervalElement, returnEdge.getExpression(), returnEdge, cfaEdge);
                break;
            }
            case DeclarationEdge: {
                successor = this.handleDeclaration(intervalElement, (DeclarationEdge)cfaEdge);
                break;
            }
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                successors = this.handleAssumption(intervalElement, assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption());
                break;
            }
            case BlankEdge: {
                successor = intervalElement.clone();
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(intervalElement, functionCallEdge, cfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                successor = this.handleFunctionReturn(intervalElement, (FunctionReturnEdge)cfaEdge);
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        if (successors != null) {
            return successors;
        }
        if (successor == null) {
            return this.noSuccessors();
        }
        return this.soleSuccessor(successor);
    }

    /*
     * Enabled aggressive block sorting
     */
    private IntervalAnalysisElement handleFunctionReturn(IntervalAnalysisElement element, FunctionReturnEdge functionReturnEdge) throws UnrecognizedCCodeException {
        CallToReturnEdge summaryEdge = functionReturnEdge.getSuccessor().getEnteringSummaryEdge();
        IASTFunctionCall expression = summaryEdge.getExpression();
        IntervalAnalysisElement newElement = element.getPreviousElement().clone();
        String callerFunctionName = functionReturnEdge.getSuccessor().getFunctionName();
        String calledFunctionName = functionReturnEdge.getPredecessor().getFunctionName();
        if (expression instanceof IASTFunctionCallAssignmentStatement) {
            IASTFunctionCallAssignmentStatement funcExp = (IASTFunctionCallAssignmentStatement)expression;
            IASTExpression operand1 = funcExp.getLeftHandSide();
            if (!(operand1 instanceof IASTIdExpression) && !(operand1 instanceof IASTFieldReference)) {
                if (!(operand1 instanceof IASTUnaryExpression)) throw new UnrecognizedCCodeException("on function return", summaryEdge, operand1);
                if (((IASTUnaryExpression)operand1).getOperator() != IASTUnaryExpression.UnaryOperator.STAR) throw new UnrecognizedCCodeException("on function return", summaryEdge, operand1);
                return element.clone();
            }
            String assignedVariableName = operand1.toASTString();
            String returnedVariableName = calledFunctionName + "::" + RETURN_VARIABLE_BASE_NAME;
            for (String globalVar : this.globalVars) {
                Interval interval;
                if (globalVar.equals(assignedVariableName)) {
                    interval = element.contains(returnedVariableName) ? element.getInterval(returnedVariableName) : Interval.createUnboundInterval();
                    newElement.addInterval(globalVar, interval, this.threshold);
                    continue;
                }
                interval = element.contains(globalVar) ? element.getInterval(globalVar) : Interval.createUnboundInterval();
                newElement.addInterval(globalVar, interval, this.threshold);
            }
            if (this.globalVars.contains(assignedVariableName)) return newElement;
            Interval interval = element.contains(returnedVariableName) ? element.getInterval(returnedVariableName) : Interval.createUnboundInterval();
            newElement.addInterval(this.constructVariableName(assignedVariableName, callerFunctionName), interval, this.threshold);
            return newElement;
        }
        if (!(expression instanceof IASTFunctionCallStatement)) throw new UnrecognizedCCodeException("on function return", summaryEdge, expression.asStatement());
        Iterator<String> i$ = this.globalVars.iterator();
        while (i$.hasNext()) {
            String globalVar = i$.next();
            Interval interval = element.contains(globalVar) ? element.getInterval(globalVar) : Interval.createUnboundInterval();
            newElement.addInterval(globalVar, interval, this.threshold);
        }
        return newElement;
    }

    private IntervalAnalysisElement handleFunctionCall(IntervalAnalysisElement previousElement, FunctionCallEdge callEdge, CFAEdge edge) throws UnrecognizedCCodeException {
        FunctionDefinitionNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> parameterNames = functionEntryNode.getFunctionParameterNames();
        List<IASTExpression> arguments = callEdge.getArguments();
        assert (parameterNames.size() == arguments.size());
        IntervalAnalysisElement newElement = new IntervalAnalysisElement(previousElement);
        for (String globalVar : this.globalVars) {
            if (!previousElement.contains(globalVar)) continue;
            newElement.addInterval(globalVar, previousElement.getInterval(globalVar), this.threshold);
        }
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(previousElement, callerFunctionName, edge);
        for (int i = 0; i < arguments.size(); ++i) {
            Interval interval = ((IASTRightHandSide)arguments.get(i)).accept(visitor);
            String formalParameterName = this.constructVariableName(parameterNames.get(i), calledFunctionName);
            newElement.addInterval(formalParameterName, interval, this.threshold);
        }
        return newElement;
    }

    private IntervalAnalysisElement handleExitFromFunction(IntervalAnalysisElement element, IASTExpression expression, ReturnStatementEdge returnEdge, CFAEdge edge) throws UnrecognizedCCodeException {
        if (expression == null) {
            expression = NumericTypes.ZERO;
        }
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(element, returnEdge.getPredecessor().getFunctionName(), edge);
        return this.handleAssignmentToVariable(RETURN_VARIABLE_BASE_NAME, expression, visitor);
    }

    private Collection<? extends AbstractElement> handleAssumption(IntervalAnalysisElement element, IASTExpression expression, CFAEdge cfaEdge, boolean truthValue) throws UnrecognizedCCodeException {
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExp = (IASTUnaryExpression)expression;
            switch (unaryExp.getOperator()) {
                case NOT: {
                    return this.handleAssumption(element, unaryExp.getOperand(), cfaEdge, !truthValue);
                }
                case STAR: {
                    return this.soleSuccessor(element.clone());
                }
            }
            throw new UnrecognizedCCodeException(cfaEdge, unaryExp);
        }
        if (expression instanceof IASTIdExpression) {
            return this.handleAssumption(element, this.convertToBinaryAssume((IASTIdExpression)expression), cfaEdge, truthValue);
        }
        if (expression instanceof IASTBinaryExpression) {
            IntervalAnalysisElement newElement = element.clone();
            IASTBinaryExpression.BinaryOperator operator = ((IASTBinaryExpression)expression).getOperator();
            IASTExpression operand1 = ((IASTBinaryExpression)expression).getOperand1();
            IASTExpression operand2 = ((IASTBinaryExpression)expression).getOperand2();
            ExpressionValueVisitor visitor = new ExpressionValueVisitor(newElement, cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
            Interval interval1 = ((IASTRightHandSide)operand1).accept(visitor);
            Interval interval2 = ((IASTRightHandSide)operand2).accept(visitor);
            switch (operator) {
                case MINUS: 
                case PLUS: {
                    Interval result = null;
                    if (operator == IASTBinaryExpression.BinaryOperator.MINUS) {
                        result = interval1.minus(interval2);
                    } else if (operator == IASTBinaryExpression.BinaryOperator.PLUS) {
                        result = interval1.plus(interval2);
                    }
                    if (truthValue && !result.isFalse() || !truthValue && !result.isTrue()) {
                        return this.soleSuccessor(newElement);
                    }
                    return this.noSuccessors();
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    return this.processAssumption(newElement, operator, operand1, operand2, truthValue, cfaEdge);
                }
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    return this.soleSuccessor(newElement);
                }
            }
            throw new UnrecognizedCCodeException(cfaEdge, expression);
        }
        return this.noSuccessors();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<? extends AbstractElement> processAssumption(IntervalAnalysisElement element, IASTBinaryExpression.BinaryOperator operator, IASTExpression operand1, IASTExpression operand2, boolean truthValue, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (!truthValue) {
            return this.processAssumption(element, this.negateOperator(operator), operand1, operand2, !truthValue, cfaEdge);
        }
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(element, cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
        Interval orgInterval1 = ((IASTRightHandSide)operand1).accept(visitor);
        Interval orgInterval2 = ((IASTRightHandSide)operand2).accept(visitor);
        Interval tmpInterval1 = orgInterval1.clone();
        Interval tmpInterval2 = orgInterval2.clone();
        String variableName1 = this.constructVariableName(operand1.toASTString(), cfaEdge.getPredecessor().getFunctionName());
        String variableName2 = this.constructVariableName(operand2.toASTString(), cfaEdge.getPredecessor().getFunctionName());
        boolean isIdOp1 = operand1 instanceof IASTIdExpression;
        boolean isIdOp2 = operand2 instanceof IASTIdExpression;
        if (operator == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
            if (!tmpInterval1.mayBeLessThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitUpperBoundBy(tmpInterval2.minus(1L)), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitLowerBoundBy(tmpInterval1.plus(1L)), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == IASTBinaryExpression.BinaryOperator.LESS_EQUAL) {
            if (!tmpInterval1.mayBeLessOrEqualThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitUpperBoundBy(tmpInterval2), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitLowerBoundBy(tmpInterval1), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
            if (!tmpInterval1.mayBeGreaterThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitLowerBoundBy(tmpInterval2.plus(1L)), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitUpperBoundBy(tmpInterval1.minus(1L)), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
            if (!tmpInterval1.mayBeGreaterOrEqualThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitLowerBoundBy(tmpInterval2), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitUpperBoundBy(tmpInterval1), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == IASTBinaryExpression.BinaryOperator.EQUALS) {
            if (!tmpInterval1.intersects(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.intersect(tmpInterval2), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.intersect(tmpInterval1), this.threshold);
            return this.soleSuccessor(element);
        } else {
            if (operator != IASTBinaryExpression.BinaryOperator.NOT_EQUALS) throw new UnrecognizedCCodeException("unknown operator", cfaEdge);
            if (tmpInterval1.isSingular() && tmpInterval1.equals(tmpInterval2)) {
                return this.noSuccessors();
            }
            if (!this.splitIntervals || !isIdOp1 || isIdOp2) return this.soleSuccessor(element);
            IntervalAnalysisElement newElement = null;
            LinkedList<IntervalAnalysisElement> successors = new LinkedList<IntervalAnalysisElement>();
            Interval result = null;
            result = orgInterval1.intersect(Interval.createUpperBoundedInterval(orgInterval2.getLow() - 1L));
            if (!result.isEmpty()) {
                newElement = element.clone();
                newElement.addInterval(variableName1, result, this.threshold);
                successors.add(newElement);
            }
            if ((result = orgInterval1.intersect(Interval.createLowerBoundedInterval(orgInterval2.getLow() + 1L))).isEmpty()) return successors;
            newElement = element.clone();
            newElement.addInterval(variableName1, result, this.threshold);
            successors.add(newElement);
            return successors;
        }
    }

    private IASTBinaryExpression.BinaryOperator negateOperator(IASTBinaryExpression.BinaryOperator operator) {
        switch (operator) {
            case EQUALS: {
                return IASTBinaryExpression.BinaryOperator.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return IASTBinaryExpression.BinaryOperator.EQUALS;
            }
            case LESS_THAN: {
                return IASTBinaryExpression.BinaryOperator.GREATER_EQUAL;
            }
            case LESS_EQUAL: {
                return IASTBinaryExpression.BinaryOperator.GREATER_THAN;
            }
            case GREATER_EQUAL: {
                return IASTBinaryExpression.BinaryOperator.LESS_THAN;
            }
            case GREATER_THAN: {
                return IASTBinaryExpression.BinaryOperator.LESS_EQUAL;
            }
        }
        return operator;
    }

    private IntervalAnalysisElement handleDeclaration(IntervalAnalysisElement element, DeclarationEdge declarationEdge) throws UnrecognizedCCodeException {
        IntervalAnalysisElement newElement = element.clone();
        if (declarationEdge.getDeclaration() instanceof IASTVariableDeclaration) {
            IASTVariableDeclaration decl = (IASTVariableDeclaration)declarationEdge.getDeclaration();
            if (decl.getDeclSpecifier() instanceof IASTPointerTypeSpecifier) {
                return newElement;
            }
            if (decl.isGlobal()) {
                Interval interval;
                this.globalVars.add(decl.getName().toString());
                IASTInitializer init = decl.getInitializer();
                if (init instanceof IASTInitializerExpression) {
                    IASTExpression exp = ((IASTInitializerExpression)init).getExpression();
                    interval = this.evaluateInterval(element, exp, "", declarationEdge);
                } else {
                    interval = new Interval(0L);
                }
                String varName = this.constructVariableName(decl.getName().toString(), "");
                newElement.addInterval(varName, interval, this.threshold);
            } else {
                String varName = this.constructVariableName(decl.getName(), declarationEdge.getPredecessor().getFunctionName());
                newElement.addInterval(varName, Interval.createUnboundInterval(), this.threshold);
            }
        }
        return newElement;
    }

    private IntervalAnalysisElement handleStatement(IntervalAnalysisElement element, IASTStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTAssignment) {
            return this.handleAssignment(element, (IASTAssignment)((Object)expression), cfaEdge);
        }
        if (expression instanceof IASTFunctionCallStatement) {
            return element.clone();
        }
        if (expression instanceof IASTExpressionStatement) {
            return element.clone();
        }
        throw new UnrecognizedCCodeException(cfaEdge, expression);
    }

    private IntervalAnalysisElement handleAssignment(IntervalAnalysisElement element, IASTAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        IASTExpression op1 = assignExpression.getLeftHandSide();
        IASTRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof IASTIdExpression) {
            ExpressionValueVisitor visitor = new ExpressionValueVisitor(element, cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
            return this.handleAssignmentToVariable(((IASTIdExpression)op1).getName(), op2, visitor);
        }
        if (op1 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op1).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
            return element.clone();
        }
        if (op1 instanceof IASTFieldReference) {
            return element.clone();
        }
        if (op1 instanceof IASTArraySubscriptExpression) {
            return element.clone();
        }
        throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
    }

    private IntervalAnalysisElement handleAssignmentToVariable(String lParam, IASTRightHandSide expression, ExpressionValueVisitor v) throws UnrecognizedCCodeException {
        Interval value = expression.accept(v);
        IntervalAnalysisElement newElement = v.element.clone();
        String variableName = this.constructVariableName(lParam, v.functionName);
        newElement.addInterval(variableName, value, this.threshold);
        return newElement;
    }

    private Interval evaluateInterval(IntervalAnalysisElement element, IASTRightHandSide expression, String functionName, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTLiteralExpression) {
            Long value = IntervalAnalysisTransferRelation.parseLiteral((IASTLiteralExpression)expression, cfaEdge);
            return value == null ? Interval.createUnboundInterval() : new Interval(value, value);
        }
        if (expression instanceof IASTIdExpression) {
            String varName = this.constructVariableName(((IASTIdExpression)expression).getName(), functionName);
            return element.contains(varName) ? element.getInterval(varName) : Interval.createUnboundInterval();
        }
        if (expression instanceof IASTCastExpression) {
            return this.evaluateInterval(element, ((IASTCastExpression)expression).getOperand(), functionName, cfaEdge);
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            IASTUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            IASTExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case MINUS: {
                    Interval interval = this.evaluateInterval(element, unaryOperand, functionName, cfaEdge);
                    return interval == null ? Interval.createUnboundInterval() : interval.negate();
                }
            }
            throw new UnrecognizedCCodeException("unknown unary operator", cfaEdge, unaryExpression);
        }
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
            Interval interval1 = this.evaluateInterval(element, binaryExpression.getOperand1(), functionName, cfaEdge);
            Interval interval2 = this.evaluateInterval(element, binaryExpression.getOperand2(), functionName, cfaEdge);
            switch (binaryExpression.getOperator()) {
                case PLUS: {
                    return interval1.plus(interval2);
                }
            }
            throw new UnrecognizedCCodeException("unknown binary operator", cfaEdge, binaryExpression);
        }
        return Interval.createUnboundInterval();
    }

    private static Long parseLiteral(IASTLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTIntegerLiteralExpression) {
            return ((IASTIntegerLiteralExpression)expression).asLong();
        }
        if (expression instanceof IASTFloatLiteralExpression) {
            return null;
        }
        if (expression instanceof IASTCharLiteralExpression) {
            return ((IASTCharLiteralExpression)expression).getCharacter();
        }
        if (expression instanceof IASTStringLiteralExpression) {
            return null;
        }
        throw new UnrecognizedCCodeException("unknown literal", edge, expression);
    }

    public String constructVariableName(String variableName, String functionName) {
        if (this.globalVars.contains(variableName)) {
            return variableName;
        }
        return functionName + "::" + variableName;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> elements, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        assert (element instanceof IntervalAnalysisElement);
        IntervalAnalysisElement intervalElement = (IntervalAnalysisElement)element;
        for (AbstractElement elem : elements) {
            if (!(elem instanceof PointerElement)) continue;
            return this.strengthen(intervalElement, (PointerElement)elem, cfaEdge, precision);
        }
        return null;
    }

    private Collection<? extends AbstractElement> strengthen(IntervalAnalysisElement intervalElement, PointerElement pointerElement, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        return null;
    }

    private Collection<? extends AbstractElement> soleSuccessor(AbstractElement successor) {
        return Collections.singleton(successor);
    }

    private Collection<? extends AbstractElement> noSuccessors() {
        return Collections.emptySet();
    }

    private IASTBinaryExpression convertToBinaryAssume(IASTIdExpression expression) {
        IASTIntegerLiteralExpression zero = new IASTIntegerLiteralExpression(expression.getFileLocation(), expression.getExpressionType(), BigInteger.ZERO);
        return new IASTBinaryExpression(expression.getFileLocation(), expression.getExpressionType(), expression, zero, IASTBinaryExpression.BinaryOperator.NOT_EQUALS);
    }

    private class ExpressionValueVisitor
    extends DefaultExpressionVisitor<Interval, UnrecognizedCCodeException>
    implements RightHandSideVisitor<Interval, UnrecognizedCCodeException> {
        protected final IntervalAnalysisElement element;
        protected final String functionName;
        protected final CFAEdge cfaEdge;

        public ExpressionValueVisitor(IntervalAnalysisElement pElement, String pFunctionName, CFAEdge edge) {
            this.element = pElement;
            this.functionName = pFunctionName;
            this.cfaEdge = edge;
        }

        @Override
        protected Interval visitDefault(IASTExpression expression) {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(IASTBinaryExpression binaryExpression) throws UnrecognizedCCodeException {
            Interval interval1 = ((IASTRightHandSide)binaryExpression.getOperand1()).accept(this);
            Interval interval2 = ((IASTRightHandSide)binaryExpression.getOperand2()).accept(this);
            if (interval1 == null || interval2 == null) {
                return Interval.createUnboundInterval();
            }
            switch (binaryExpression.getOperator()) {
                case PLUS: {
                    return interval1.plus(interval2);
                }
                case MINUS: {
                    return interval1.minus(interval2);
                }
                case MULTIPLY: {
                    return interval1.times(interval2);
                }
                case DIVIDE: {
                    return interval1.divide(interval2);
                }
                case SHIFT_LEFT: {
                    return interval1.shiftLeft(interval2);
                }
                case SHIFT_RIGHT: {
                    return interval1.shiftRight(interval2);
                }
                case EQUALS: {
                    return new Interval(interval1.intersects(interval2) ? 1L : 0L);
                }
                case NOT_EQUALS: {
                    return new Interval(!interval1.intersects(interval2) ? 1L : 0L);
                }
                case GREATER_THAN: {
                    return new Interval(interval1.mayBeGreaterThan(interval2) ? 1L : 0L);
                }
                case GREATER_EQUAL: {
                    return new Interval(interval1.mayBeGreaterOrEqualThan(interval2) ? 1L : 0L);
                }
                case LESS_THAN: {
                    return new Interval(interval1.mayBeLessThan(interval2) ? 1L : 0L);
                }
                case LESS_EQUAL: {
                    return new Interval(interval1.mayBeLessOrEqualThan(interval2) ? 1L : 0L);
                }
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: 
                case MODULO: {
                    return Interval.createUnboundInterval();
                }
            }
            throw new UnrecognizedCCodeException("unkown binary operator", this.cfaEdge, binaryExpression);
        }

        @Override
        public Interval visit(IASTCastExpression cast) throws UnrecognizedCCodeException {
            return ((IASTRightHandSide)cast.getOperand()).accept(this);
        }

        @Override
        public Interval visit(IASTFunctionCallExpression functionCall) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(IASTCharLiteralExpression charLiteral) throws UnrecognizedCCodeException {
            Long l = IntervalAnalysisTransferRelation.parseLiteral(charLiteral, this.cfaEdge);
            return l == null ? Interval.createUnboundInterval() : new Interval(l);
        }

        @Override
        public Interval visit(IASTFloatLiteralExpression floatLiteral) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(IASTIntegerLiteralExpression integerLiteral) throws UnrecognizedCCodeException {
            return new Interval(IntervalAnalysisTransferRelation.parseLiteral(integerLiteral, this.cfaEdge));
        }

        @Override
        public Interval visit(IASTStringLiteralExpression stringLiteral) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(IASTIdExpression identifier) throws UnrecognizedCCodeException {
            if (identifier.getDeclaration() instanceof IASTEnumerationSpecifier.IASTEnumerator) {
                return new Interval(((IASTEnumerationSpecifier.IASTEnumerator)identifier.getDeclaration()).getValue());
            }
            String variableName = IntervalAnalysisTransferRelation.this.constructVariableName(identifier.getName(), this.functionName);
            if (this.element.contains(variableName)) {
                return this.element.getInterval(variableName);
            }
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(IASTUnaryExpression unaryExpression) throws UnrecognizedCCodeException {
            IASTUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            IASTExpression unaryOperand = unaryExpression.getOperand();
            Interval interval = ((IASTRightHandSide)unaryOperand).accept(this);
            switch (unaryOperator) {
                case MINUS: {
                    return interval != null ? interval.negate() : Interval.createUnboundInterval();
                }
                case NOT: {
                    if (interval.isFalse()) {
                        return Interval.createTrueInterval();
                    }
                    if (interval.isTrue()) {
                        return Interval.createFalseInterval();
                    }
                    return new Interval(0L, 1L);
                }
                case AMPER: {
                    return Interval.createUnboundInterval();
                }
                case STAR: {
                    return Interval.createUnboundInterval();
                }
            }
            throw new UnrecognizedCCodeException("unknown unary operator", this.cfaEdge, unaryExpression);
        }
    }
}

