/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsElement;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

enum InvariantsDomain implements AbstractDomain
{
    INSTANCE;


    @Override
    public InvariantsElement join(AbstractElement pElement1, AbstractElement pElement2) {
        InvariantsElement element1 = (InvariantsElement)pElement1;
        InvariantsElement element2 = (InvariantsElement)pElement2;
        MapDifference differences = Maps.difference(element1.getIntervals(), element2.getIntervals());
        if (differences.areEqual()) {
            return element2;
        }
        HashMap<String, SimpleInterval> result = new HashMap<String, SimpleInterval>(element1.getIntervals().size());
        result.putAll(differences.entriesInCommon());
        for (Map.Entry entry : differences.entriesDiffering().entrySet()) {
            MapDifference.ValueDifference values = (MapDifference.ValueDifference)entry.getValue();
            result.put((String)entry.getKey(), SimpleInterval.span((SimpleInterval)values.leftValue(), (SimpleInterval)values.rightValue()));
        }
        return new InvariantsElement(result);
    }

    @Override
    public boolean isLessOrEqual(AbstractElement pElement1, AbstractElement pElement2) {
        InvariantsElement element1 = (InvariantsElement)pElement1;
        InvariantsElement element2 = (InvariantsElement)pElement2;
        MapDifference differences = Maps.difference(element1.getIntervals(), element2.getIntervals());
        if (differences.areEqual()) {
            return true;
        }
        if (!differences.entriesOnlyOnRight().isEmpty()) {
            return false;
        }
        for (MapDifference.ValueDifference values : differences.entriesDiffering().values()) {
            if (((SimpleInterval)values.rightValue()).contains((SimpleInterval)values.leftValue())) continue;
            return false;
        }
        return true;
    }
}

