/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingElement;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class InvariantsElement
implements AbstractElement,
FormulaReportingElement {
    private final Map<String, SimpleInterval> vars;

    InvariantsElement() {
        this.vars = new HashMap<String, SimpleInterval>();
    }

    InvariantsElement(Map<String, SimpleInterval> pVars) {
        this.vars = new HashMap<String, SimpleInterval>(pVars);
    }

    public SimpleInterval get(String var) {
        return (SimpleInterval)Objects.firstNonNull((Object)this.vars.get(var), (Object)SimpleInterval.infinite());
    }

    public Map<String, SimpleInterval> getIntervals() {
        return Collections.unmodifiableMap(this.vars);
    }

    InvariantsElement copyAndSet(String var, SimpleInterval value) {
        SimpleInterval oldValue = this.vars.get(var);
        if (value.equals(oldValue)) {
            return this;
        }
        if (!value.hasLowerBound() && !value.hasLowerBound()) {
            if (oldValue != null) {
                InvariantsElement result = new InvariantsElement(this.vars);
                result.vars.remove(var);
                return result;
            }
            return this;
        }
        InvariantsElement result = new InvariantsElement(this.vars);
        result.vars.put((String)Preconditions.checkNotNull((Object)var), (SimpleInterval)Preconditions.checkNotNull((Object)value));
        return result;
    }

    @Override
    public Formula getFormulaApproximation(FormulaManager pManager) {
        Formula result = pManager.makeTrue();
        for (Map.Entry<String, SimpleInterval> entry : this.vars.entrySet()) {
            Formula f;
            Formula bound;
            Formula var = pManager.makeVariable(entry.getKey());
            SimpleInterval value = entry.getValue();
            if (value.hasLowerBound()) {
                bound = pManager.makeNumber(value.getLowerBound().toString());
                f = pManager.makeGeq(var, bound);
                result = pManager.makeAnd(result, f);
            }
            if (!value.hasUpperBound()) continue;
            bound = pManager.makeNumber(value.getUpperBound().toString());
            f = pManager.makeLeq(var, bound);
            result = pManager.makeAnd(result, f);
        }
        return result;
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof InvariantsElement)) {
            return false;
        }
        return ((Object)this.vars).equals(((InvariantsElement)pObj).vars);
    }

    public int hashCode() {
        return ((Object)this.vars).hashCode();
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator("=").join(this.vars);
    }
}

