/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsElement;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

final class InvariantsTransferRelation
extends Enum<InvariantsTransferRelation>
implements TransferRelation {
    public static final /* enum */ InvariantsTransferRelation INSTANCE = new InvariantsTransferRelation();
    private static final /* synthetic */ InvariantsTransferRelation[] $VALUES;

    public static InvariantsTransferRelation[] values() {
        return (InvariantsTransferRelation[])$VALUES.clone();
    }

    public static InvariantsTransferRelation valueOf(String name) {
        return Enum.valueOf(InvariantsTransferRelation.class, name);
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge edge) throws CPATransferException {
        InvariantsElement element = (InvariantsElement)pElement;
        switch (edge.getEdgeType()) {
            case BlankEdge: 
            case FunctionReturnEdge: 
            case ReturnStatementEdge: {
                break;
            }
            case AssumeEdge: {
                element = this.handleAssume(element, (AssumeEdge)edge);
                break;
            }
            case DeclarationEdge: {
                element = this.handleDeclaration(element, (DeclarationEdge)edge);
                break;
            }
            case FunctionCallEdge: {
                element = this.handleFunctionCall(element, (FunctionCallEdge)edge);
                break;
            }
            case StatementEdge: {
                element = this.handleStatement(element, (StatementEdge)edge);
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(edge);
            }
        }
        if (element == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(element);
    }

    private InvariantsElement handleAssume(InvariantsElement element, AssumeEdge edge) throws UnrecognizedCCodeException {
        IASTExpression operand1;
        IASTBinaryExpression binExp;
        IASTExpression exp = edge.getExpression();
        if (exp instanceof IASTBinaryExpression && (binExp = (IASTBinaryExpression)exp).getOperator() == IASTBinaryExpression.BinaryOperator.EQUALS && (operand1 = binExp.getOperand1()) instanceof IASTIdExpression) {
            String var = InvariantsTransferRelation.getVarName((IASTIdExpression)operand1, edge);
            SimpleInterval varValue = element.get(var);
            SimpleInterval value = ((IASTRightHandSide)binExp.getOperand2()).accept(SimpleRightHandSideValueVisitor.VISITOR_INSTANCE);
            if (value.isSingleton()) {
                if (edge.getTruthAssumption()) {
                    if (!varValue.intersectsWith(value)) {
                        return null;
                    }
                    element = element.copyAndSet(var, value);
                } else if (varValue.equals(value)) {
                    return null;
                }
            } else assert (!value.hasLowerBound() && !value.hasUpperBound());
        }
        return element;
    }

    private InvariantsElement handleDeclaration(InvariantsElement element, DeclarationEdge edge) throws UnrecognizedCCodeException {
        if (!(edge.getDeclaration() instanceof IASTVariableDeclaration)) {
            return element;
        }
        IASTVariableDeclaration decl = (IASTVariableDeclaration)edge.getDeclaration();
        String varName = decl.getName();
        if (!decl.isGlobal()) {
            varName = edge.getSuccessor().getFunctionName() + "::" + varName;
        }
        SimpleInterval value = SimpleInterval.infinite();
        if (decl.getInitializer() != null && decl.getInitializer() instanceof IASTInitializerExpression) {
            IASTExpression init = ((IASTInitializerExpression)decl.getInitializer()).getExpression();
            value = ((IASTRightHandSide)init).accept(SimpleRightHandSideValueVisitor.VISITOR_INSTANCE);
        }
        return element.copyAndSet(varName, value);
    }

    private InvariantsElement handleFunctionCall(InvariantsElement element, FunctionCallEdge edge) throws UnrecognizedCCodeException {
        InvariantsElement newElement = element;
        List<String> formalParams = edge.getSuccessor().getFunctionParameterNames();
        List<IASTExpression> actualParams = edge.getArguments();
        for (Pair param : Pair.zipList(formalParams, actualParams)) {
            IASTExpression actualParam = (IASTExpression)param.getSecond();
            SimpleInterval value = ((IASTRightHandSide)actualParam).accept(SimpleRightHandSideValueVisitor.VISITOR_INSTANCE);
            if (actualParam instanceof IASTIdExpression) {
                String var = InvariantsTransferRelation.getVarName((IASTIdExpression)actualParam, edge);
                value = element.get(var);
            }
            String formalParam = InvariantsTransferRelation.scope((String)param.getFirst(), edge.getSuccessor().getFunctionName());
            newElement = newElement.copyAndSet(formalParam, value);
        }
        return newElement;
    }

    private InvariantsElement handleStatement(InvariantsElement element, StatementEdge edge) throws UnrecognizedCCodeException {
        if (edge.getStatement() instanceof IASTAssignment) {
            IASTAssignment assignment = (IASTAssignment)((Object)edge.getStatement());
            IASTExpression leftHandSide = assignment.getLeftHandSide();
            if (leftHandSide instanceof IASTIdExpression) {
                String varName = InvariantsTransferRelation.getVarName((IASTIdExpression)leftHandSide, edge);
                IASTRightHandSide rightHandSide = assignment.getRightHandSide();
                SimpleInterval rightHandValue = rightHandSide.accept(SimpleRightHandSideValueVisitor.VISITOR_INSTANCE);
                if (rightHandSide instanceof IASTBinaryExpression) {
                    String rightHandVar;
                    IASTExpression operand1;
                    IASTBinaryExpression binExp = (IASTBinaryExpression)rightHandSide;
                    if (binExp.getOperator() == IASTBinaryExpression.BinaryOperator.PLUS && (operand1 = binExp.getOperand1()) instanceof IASTIdExpression && varName.equals(rightHandVar = InvariantsTransferRelation.getVarName((IASTIdExpression)operand1, edge))) {
                        rightHandValue = element.get(varName);
                        SimpleInterval incrementValue = ((IASTRightHandSide)binExp.getOperand2()).accept(SimpleRightHandSideValueVisitor.VISITOR_INSTANCE);
                        if (incrementValue.containsPositive()) {
                            rightHandValue = rightHandValue.extendToPositiveInfinity();
                        }
                        if (incrementValue.containsNegative()) {
                            rightHandValue = rightHandValue.extendToNegativeInfinity();
                        }
                    }
                } else if (rightHandSide instanceof IASTIdExpression) {
                    String var = InvariantsTransferRelation.getVarName((IASTIdExpression)rightHandSide, edge);
                    rightHandValue = element.get(var);
                }
                element = element.copyAndSet(varName, rightHandValue);
            } else {
                throw new UnrecognizedCCodeException("unknown left-hand side of assignment", edge, leftHandSide);
            }
        }
        return element;
    }

    private static String getVarName(IASTIdExpression var, CFAEdge edge) throws UnrecognizedCCodeException {
        String varName = var.getName();
        if (var.getDeclaration() != null) {
            IASTSimpleDeclaration decl = var.getDeclaration();
            if (!(decl instanceof IASTDeclaration) && !(decl instanceof IASTParameterDeclaration)) {
                throw new UnrecognizedCCodeException("unknown variable declaration", edge, var);
            }
            if (!(decl instanceof IASTDeclaration) || !((IASTDeclaration)decl).isGlobal()) {
                varName = InvariantsTransferRelation.scope(varName, edge.getPredecessor().getFunctionName());
            }
        }
        return varName;
    }

    private static String scope(String var, String function) {
        return function + "::" + var;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }

    static {
        $VALUES = new InvariantsTransferRelation[]{INSTANCE};
    }

    private static class SimpleRightHandSideValueVisitor
    extends DefaultExpressionVisitor<SimpleInterval, UnrecognizedCCodeException>
    implements RightHandSideVisitor<SimpleInterval, UnrecognizedCCodeException> {
        private static SimpleRightHandSideValueVisitor VISITOR_INSTANCE = new SimpleRightHandSideValueVisitor();

        private SimpleRightHandSideValueVisitor() {
        }

        @Override
        protected SimpleInterval visitDefault(IASTExpression pExp) {
            return SimpleInterval.infinite();
        }

        @Override
        public SimpleInterval visit(IASTFunctionCallExpression pIastFunctionCallExpression) {
            return this.visitDefault(null);
        }

        @Override
        public SimpleInterval visit(IASTIntegerLiteralExpression pE) {
            return SimpleInterval.singleton(pE.getValue());
        }

        @Override
        public SimpleInterval visit(IASTCharLiteralExpression pE) {
            return SimpleInterval.singleton(BigInteger.valueOf(pE.getCharacter()));
        }

        @Override
        public SimpleInterval visit(IASTCastExpression pE) throws UnrecognizedCCodeException {
            SimpleInterval operand = ((IASTRightHandSide)pE.getOperand()).accept(this);
            return operand;
        }

        @Override
        public SimpleInterval visit(IASTUnaryExpression pE) throws UnrecognizedCCodeException {
            switch (pE.getOperator()) {
                case MINUS: {
                    SimpleInterval operand = ((IASTRightHandSide)pE.getOperand()).accept(this);
                    return operand.negate();
                }
            }
            return (SimpleInterval)super.visit(pE);
        }
    }
}

