/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import java.math.BigInteger;
import junit.framework.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

public class SimpleIntervalTest {
    @Test
    public void testConstruction() {
        Assert.assertNotNull((Object)SimpleInterval.singleton(BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.lessOrEqual(BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.greaterOrEqual(BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        Assert.assertNotNull((Object)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstruction1() {
        SimpleInterval.of(BigInteger.ONE, BigInteger.ZERO);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstruction2() {
        SimpleInterval.of(BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MIN_VALUE));
    }

    @Test
    public void testIsSingleton() {
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.ZERO).isSingleton());
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.lessOrEqual(BigInteger.ZERO).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.greaterOrEqual(BigInteger.ZERO).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton());
        Assert.assertTrue((boolean)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.singleton(BigInteger.ZERO).size());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)).size());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.lessOrEqual(BigInteger.ZERO).size());
        Assert.assertNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.greaterOrEqual(BigInteger.ZERO).size());
        Assert.assertNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).size());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO).size());
        Assert.assertEquals((Object)BigInteger.valueOf(2L), (Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE).size());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).size());
        Assert.assertEquals((Object)BigInteger.valueOf(201L), (Object)SimpleInterval.of(BigInteger.valueOf(-100L), BigInteger.valueOf(100L)).size());
        Assert.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(Long.MIN_VALUE)).add(BigInteger.ONE), (Object)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)).size());
    }
}

