/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.ldd;

import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.ldd.LDDAbstractElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.ldd.LDDRegionManager;

public class LDDAbstractDomain
implements AbstractDomain {
    private final LDDRegionManager regionManager;
    private final AbstractElement topElement;

    public LDDAbstractDomain(LDDRegionManager regionManager) {
        this.regionManager = regionManager;
        this.topElement = new LDDAbstractElement(regionManager.makeTrue());
    }

    @Override
    public boolean isLessOrEqual(AbstractElement newElement, AbstractElement reachedElement) throws CPAException {
        if (this.topElement.equals(reachedElement) || newElement.equals(reachedElement)) {
            return true;
        }
        if (newElement instanceof LDDAbstractElement && reachedElement instanceof LDDAbstractElement) {
            LDDAbstractElement lddElement1 = (LDDAbstractElement)newElement;
            LDDAbstractElement lddElement2 = (LDDAbstractElement)reachedElement;
            return this.regionManager.entails(lddElement1.getRegion(), lddElement2.getRegion());
        }
        return false;
    }

    @Override
    public AbstractElement join(AbstractElement pElement1, AbstractElement pElement2) throws CPAException {
        if (this.isLessOrEqual(pElement1, pElement2)) {
            return pElement2;
        }
        if (this.isLessOrEqual(pElement2, pElement1)) {
            return pElement1;
        }
        if (pElement1 instanceof LDDAbstractElement && pElement2 instanceof LDDAbstractElement) {
            LDDAbstractElement lddElement1 = (LDDAbstractElement)pElement1;
            LDDAbstractElement lddElement2 = (LDDAbstractElement)pElement2;
            return new LDDAbstractElement(this.regionManager.makeOr(lddElement1.getRegion(), lddElement2.getRegion()));
        }
        return this.topElement;
    }
}

