/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.ldd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.BasicType;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.ldd.LDDAbstractDomain;
import org.sosy_lab.cpachecker.cpa.ldd.LDDAbstractElement;
import org.sosy_lab.cpachecker.cpa.ldd.LDDAbstractionTransferRelation;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.ldd.LDDRegionManager;

public class LDDAbstractionCPA
implements ConfigurableProgramAnalysis {
    private final LDDAbstractDomain domain;
    private final StopOperator stopOperator;
    private final LDDAbstractionTransferRelation transferRelation;
    private final LDDRegionManager regionManager;
    private final LDDAbstractElement initialElement;
    private final Map<String, Integer> variables = new HashMap<String, Integer>();
    private final Set<String> constants = new HashSet<String>();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(LDDAbstractionCPA.class);
    }

    public LDDAbstractionCPA(CFA cfa, Configuration config, LogManager logger) throws InvalidConfigurationException {
        for (CFANode cFANode : cfa.getAllNodes()) {
            for (CFAEdge edge : CFAUtils.leavingEdges(cFANode)) {
                if (!(edge instanceof DeclarationEdge)) continue;
                DeclarationEdge declarationEdge = (DeclarationEdge)edge;
                IASTDeclaration declaration = declarationEdge.getDeclaration();
                if (declaration instanceof IASTVariableDeclaration) {
                    String name = declaration.getName();
                    IType type = declaration.getDeclSpecifier();
                    this.registerVariable(name, type);
                    continue;
                }
                if (!(declaration instanceof IASTFunctionDeclaration)) continue;
                IASTFunctionDeclaration funDecl = (IASTFunctionDeclaration)declaration;
                for (IASTParameterDeclaration paramDecl : funDecl.getDeclSpecifier().getParameters()) {
                    String name = paramDecl.getName();
                    IType type = paramDecl.getDeclSpecifier();
                    this.registerVariable(name, type);
                }
            }
        }
        for (CFAFunctionDefinitionNode cFAFunctionDefinitionNode : cfa.getAllFunctionHeads()) {
            if (!(cFAFunctionDefinitionNode instanceof FunctionDefinitionNode)) continue;
            FunctionDefinitionNode fDefNode = (FunctionDefinitionNode)cFAFunctionDefinitionNode;
            for (IASTParameterDeclaration paramDecl : fDefNode.getFunctionDefinition().getDeclSpecifier().getParameters()) {
                String name = paramDecl.getName();
                IType type = paramDecl.getDeclSpecifier();
                this.registerVariable(name, type);
            }
        }
        this.regionManager = new LDDRegionManager(this.variables.size());
        this.domain = new LDDAbstractDomain(this.regionManager);
        this.stopOperator = new StopSepOperator(this.domain);
        this.initialElement = new LDDAbstractElement(this.regionManager.makeTrue());
        this.transferRelation = new LDDAbstractionTransferRelation(this.regionManager, this.variables, this.constants);
    }

    private void registerVariable(String name, IType type) {
        BasicType basicType;
        if (name != null && !name.isEmpty() && type != null && type instanceof IASTSimpleDeclSpecifier && (basicType = ((IASTSimpleDeclSpecifier)type).getType()) == BasicType.INT) {
            this.variables.put(name, this.variables.size());
            if (type.isConst()) {
                this.constants.add(name);
            }
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        return this.initialElement;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }
}

