/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class InverseLocationTransferRelation
implements TransferRelation {
    private final LocationElement.LocationElementFactory factory;

    public InverseLocationTransferRelation(LocationElement.LocationElementFactory pFactory) {
        this.factory = pFactory;
    }

    private Collection<LocationElement> getAbstractSuccessor(AbstractElement element, CFAEdge cfaEdge, Precision prec) throws CPATransferException {
        LocationElement inputElement = (LocationElement)element;
        CFANode node = inputElement.getLocationNode();
        int numEnteringEdges = node.getNumEnteringEdges();
        for (int edgeIdx = 0; edgeIdx < numEnteringEdges; ++edgeIdx) {
            CFAEdge testEdge = node.getEnteringEdge(edgeIdx);
            if (testEdge != cfaEdge) continue;
            return Collections.singleton(this.factory.getElement(testEdge.getPredecessor()));
        }
        if (node.getEnteringSummaryEdge() != null) {
            CallToReturnEdge summaryEdge = node.getEnteringSummaryEdge();
            return Collections.singleton(this.factory.getElement(summaryEdge.getPredecessor()));
        }
        return Collections.emptySet();
    }

    public Collection<LocationElement> getAbstractSuccessors(AbstractElement element, Precision prec, CFAEdge cfaEdge) throws CPATransferException {
        if (cfaEdge != null) {
            return this.getAbstractSuccessor(element, cfaEdge, prec);
        }
        CFANode node = ((LocationElement)element).getLocationNode();
        int numEnteringEdges = node.getNumEnteringEdges();
        ArrayList<LocationElement> allSuccessors = new ArrayList<LocationElement>(numEnteringEdges);
        for (int edgeIdx = 0; edgeIdx < numEnteringEdges; ++edgeIdx) {
            CFAEdge tempEdge = node.getEnteringEdge(edgeIdx);
            allSuccessors.add(this.factory.getElement(tempEdge.getPredecessor()));
        }
        return allSuccessors;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }
}

