/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.location.InverseLocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;

class LocationCPAFactory
extends AbstractCPAFactory {
    private final boolean inverse;
    private CFA cfa;

    public LocationCPAFactory(boolean pInverse) {
        this.inverse = pInverse;
    }

    @Override
    public <T> LocationCPAFactory set(T pObject, Class<T> pClass) {
        if (CFA.class.isAssignableFrom(pClass)) {
            this.cfa = (CFA)pObject;
        } else {
            super.set(pObject, pClass);
        }
        return this;
    }

    @Override
    public ConfigurableProgramAnalysis createInstance() {
        Preconditions.checkNotNull((Object)this.cfa, (Object)"CFA instance needed to create LocationCPA");
        if (this.inverse) {
            return new InverseLocationCPA(this.cfa);
        }
        return new LocationCPA(this.cfa);
    }
}

