/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElementWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class LocationElement
implements AbstractElementWithLocation,
AbstractQueryableElement,
Partitionable,
Serializable {
    private static final long serialVersionUID = -801176497691618779L;
    private transient CFANode locationNode;

    private LocationElement(CFANode locationNode) {
        this.locationNode = locationNode;
    }

    @Override
    public CFANode getLocationNode() {
        return this.locationNode;
    }

    public String toString() {
        return this.locationNode + " (line " + this.locationNode.getLineNumber() + ")";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        if (parts[0].toLowerCase().equals("line")) {
            try {
                int queryLine = Integer.parseInt(parts[1]);
                return this.locationNode.getLineNumber() == queryLine;
            }
            catch (NumberFormatException nfe) {
                throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the integer \"" + parts[1] + "\"");
            }
        }
        if (parts[0].toLowerCase().equals("functionname")) {
            return this.locationNode.getFunctionName().equals(parts[1]);
        }
        throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. \"" + parts[0] + "\" is no valid keyword");
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("The location CPA does not support modification.");
    }

    @Override
    public String getCPAName() {
        return "location";
    }

    @Override
    public Boolean evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialProxy(this.locationNode.getNodeNumber());
    }

    private static class SerialProxy
    implements Serializable {
        private static final long serialVersionUID = 6889568471468710163L;
        private final int nodeNumber;

        public SerialProxy(int nodeNumber) {
            this.nodeNumber = nodeNumber;
        }

        private Object readResolve() throws ObjectStreamException {
            CFAInfo cfaInfo = GlobalInfo.getInstance().getCFAInfo();
            return cfaInfo.getLocationElementFactory().getElement(cfaInfo.getNodeByNodeNumber(this.nodeNumber));
        }
    }

    public static class LocationElementFactory {
        private final LocationElement[] elements;

        public LocationElementFactory(CFA pCfa) {
            this.elements = LocationElementFactory.initialize((CFA)Preconditions.checkNotNull((Object)pCfa));
        }

        private static LocationElement[] initialize(CFA pCfa) {
            ImmutableSortedSet allNodes = ImmutableSortedSet.copyOf(pCfa.getAllNodes());
            int maxNodeNumber = ((CFANode)allNodes.last()).getNodeNumber();
            LocationElement[] elements = new LocationElement[maxNodeNumber + 1];
            for (CFANode node : allNodes) {
                elements[node.getNodeNumber()] = new LocationElement(node);
            }
            return elements;
        }

        public LocationElement getElement(CFANode node) {
            return (LocationElement)Preconditions.checkNotNull((Object)this.elements[node.getNodeNumber()]);
        }
    }
}

