/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopstack;

import com.google.common.collect.ImmutableMultimap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackElement;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class LoopstackCPA
extends AbstractCPA {
    private final CFA cfa;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(LoopstackCPA.class);
    }

    public LoopstackCPA(Configuration config, CFA pCfa) throws InvalidConfigurationException, CPAException {
        super("sep", "sep", new LoopstackTransferRelation(config, pCfa));
        this.cfa = pCfa;
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        if (pNode instanceof CFAFunctionDefinitionNode) {
            return new LoopstackElement();
        }
        CFAUtils.Loop loop = null;
        for (CFAUtils.Loop l : ((ImmutableMultimap)this.cfa.getLoopStructure().get()).get((Object)pNode.getFunctionName())) {
            if (l.getLoopNodes().contains((Object)pNode)) assert (loop == null) : "Cannot create initial nodes for locations in nested loops";
            loop = l;
        }
        LoopstackElement e = new LoopstackElement();
        if (loop != null) {
            e = new LoopstackElement(e, loop, 0, false);
        }
        return e;
    }
}

