/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopstack;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingElement;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class LoopstackElement
implements AbstractElement,
Partitionable,
AvoidanceReportingElement {
    private final LoopstackElement previousElement;
    private final CFAUtils.Loop loop;
    private final int depth;
    private final int iteration;
    private final boolean stop;

    public LoopstackElement(LoopstackElement previousElement, CFAUtils.Loop loop, int iteration, boolean stop) {
        this.previousElement = (LoopstackElement)Preconditions.checkNotNull((Object)previousElement);
        this.loop = (CFAUtils.Loop)Preconditions.checkNotNull((Object)loop);
        this.depth = previousElement.getDepth() + 1;
        Preconditions.checkArgument((iteration >= 0 ? 1 : 0) != 0);
        this.iteration = iteration;
        this.stop = stop;
    }

    public LoopstackElement() {
        this.previousElement = null;
        this.loop = null;
        this.depth = 0;
        this.iteration = 0;
        this.stop = false;
    }

    public LoopstackElement getPreviousElement() {
        return this.previousElement;
    }

    public CFAUtils.Loop getLoop() {
        return this.loop;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.stop;
    }

    public String toString() {
        if (this.loop == null) {
            return "Loop stack empty";
        }
        return " Loop starting at node " + this.loop.getLoopHeads() + " in iteration " + this.iteration + ", stack depth " + this.depth + " [" + Integer.toHexString(super.hashCode()) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoopstackElement)) {
            return false;
        }
        LoopstackElement other = (LoopstackElement)obj;
        return this.previousElement == other.previousElement && this.iteration == other.iteration && this.loop == other.loop;
    }

    public int hashCode() {
        return this.iteration * 17 + (this.loop == null ? 0 : this.loop.hashCode());
    }

    @Override
    public Formula getReasonFormula(FormulaManager manager) {
        if (this.stop) {
            return manager.parse(PreventingHeuristic.LOOPITERATIONS.getFormulaString(this.iteration));
        }
        return manager.makeTrue();
    }
}

