/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopstack;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="cpa.loopstack")
public class LoopstackTransferRelation
implements TransferRelation {
    @Option(description="threshold for unrolling loops of the program (0 is infinite)\nworks only if assumption storage CPA is enabled, because otherwise it would be unsound")
    private int maxLoopIterations = 0;
    private Map<CFAEdge, CFAUtils.Loop> loopEntryEdges = null;
    private Map<CFAEdge, CFAUtils.Loop> loopExitEdges = null;
    private Multimap<CFANode, CFAUtils.Loop> loopHeads = null;

    public LoopstackTransferRelation(Configuration config, CFA pCfa) throws InvalidConfigurationException, InvalidCFAException {
        config.inject((Object)this);
        if (!pCfa.getLoopStructure().isPresent()) {
            throw new InvalidCFAException("LoopstackCPA does not work without loop information!");
        }
        Multimap loops = (Multimap)pCfa.getLoopStructure().get();
        ImmutableMap.Builder entryEdges = ImmutableMap.builder();
        ImmutableMap.Builder exitEdges = ImmutableMap.builder();
        ImmutableMultimap.Builder heads = ImmutableMultimap.builder();
        for (CFAUtils.Loop l : loops.values()) {
            Iterable incomingEdges = Iterables.filter(l.getIncomingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(FunctionReturnEdge.class)));
            Iterable outgoingEdges = Iterables.filter(l.getOutgoingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(FunctionCallEdge.class)));
            for (CFAEdge e : incomingEdges) {
                entryEdges.put((Object)e, (Object)l);
            }
            for (CFAEdge e : outgoingEdges) {
                exitEdges.put((Object)e, (Object)l);
            }
            for (CFANode h : l.getLoopHeads()) {
                heads.put((Object)h, (Object)l);
            }
        }
        this.loopEntryEdges = entryEdges.build();
        this.loopExitEdges = exitEdges.build();
        this.loopHeads = heads.build();
    }

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        if (pCfaEdge instanceof FunctionCallEdge) {
            return Collections.singleton(pElement);
        }
        CFANode loc = pCfaEdge.getSuccessor();
        LoopstackElement e = (LoopstackElement)pElement;
        CFAUtils.Loop oldLoop = this.loopExitEdges.get(pCfaEdge);
        if (oldLoop != null) {
            assert (oldLoop.equals(e.getLoop())) : e + " " + oldLoop + " " + pCfaEdge;
            e = e.getPreviousElement();
        }
        if (pCfaEdge instanceof FunctionReturnEdge) {
            return Collections.singleton(pElement);
        }
        CFAUtils.Loop newLoop = this.loopEntryEdges.get(pCfaEdge);
        if (newLoop != null) {
            e = new LoopstackElement(e, newLoop, 0, false);
        }
        Collection loops = this.loopHeads.get((Object)loc);
        assert (loops.size() <= 1);
        if (loops.contains(e.getLoop())) {
            boolean stop = this.maxLoopIterations > 0 && e.getIteration() >= this.maxLoopIterations;
            e = new LoopstackElement(e.getPreviousElement(), e.getLoop(), e.getIteration() + 1, stop);
        }
        return Collections.singleton(e);
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }
}

