/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingElement;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class MonitorElement
extends AbstractSingleWrapperElement
implements AvoidanceReportingElement {
    private final long totalTimeOnPath;
    private final Pair<PreventingHeuristic, Long> preventingCondition;

    protected MonitorElement(AbstractElement pWrappedElement, long totalTimeOnPath) {
        this(pWrappedElement, totalTimeOnPath, null);
    }

    protected MonitorElement(AbstractElement pWrappedElement, long totalTimeOnPath, Pair<PreventingHeuristic, Long> preventingCondition) {
        super(pWrappedElement);
        Preconditions.checkArgument((!(pWrappedElement instanceof MonitorElement) ? 1 : 0) != 0, (Object)"Don't wrap a MonitorCPA in a MonitorCPA, this makes no sense!");
        Preconditions.checkArgument((pWrappedElement != TimeoutElement.INSTANCE || preventingCondition != null ? 1 : 0) != 0, (Object)"Need a preventingCondition in case of TimeoutElement");
        this.totalTimeOnPath = totalTimeOnPath;
        this.preventingCondition = preventingCondition;
    }

    public long getTotalTimeOnPath() {
        return this.totalTimeOnPath;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof MonitorElement) {
            MonitorElement otherElem = (MonitorElement)pObj;
            return this.getWrappedElement().equals(otherElem.getWrappedElement());
        }
        return false;
    }

    public int hashCode() {
        return this.getWrappedElement().hashCode();
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.preventingCondition != null;
    }

    Pair<PreventingHeuristic, Long> getPreventingCondition() {
        return this.preventingCondition;
    }

    @Override
    public String toString() {
        return "Total time: " + this.totalTimeOnPath + " Wrapped elem: " + this.getWrappedElements();
    }

    @Override
    public Formula getReasonFormula(FormulaManager manager) {
        if (this.mustDumpAssumptionForAvoidance()) {
            String preventingHeuristicStringFormula = ((PreventingHeuristic)((Object)this.preventingCondition.getFirst())).getFormulaString((Long)this.preventingCondition.getSecond());
            return manager.parse(preventingHeuristicStringFormula);
        }
        return manager.makeTrue();
    }

    static enum TimeoutElement implements AbstractElement
    {
        INSTANCE;


        public String toString() {
            return "Dummy element because computation timed out";
        }
    }
}

