/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class MonitorMerge
implements MergeOperator {
    private ConfigurableProgramAnalysis wrappedCpa;

    public MonitorMerge(ConfigurableProgramAnalysis pWrappedCPA) {
        this.wrappedCpa = pWrappedCPA;
    }

    @Override
    public AbstractElement merge(AbstractElement pElement1, AbstractElement pElement2, Precision pPrecision) throws CPAException {
        AbstractElement wrappedElement2;
        AbstractElement wrappedElement1;
        MonitorElement monitorElement1 = (MonitorElement)pElement1;
        MonitorElement monitorElement2 = (MonitorElement)pElement2;
        if (monitorElement1.mustDumpAssumptionForAvoidance() || monitorElement2.mustDumpAssumptionForAvoidance()) {
            return pElement2;
        }
        MergeOperator mergeOperator = this.wrappedCpa.getMergeOperator();
        AbstractElement retElement = mergeOperator.merge(wrappedElement1 = monitorElement1.getWrappedElement(), wrappedElement2 = monitorElement2.getWrappedElement(), pPrecision);
        if (retElement.equals(wrappedElement2)) {
            return pElement2;
        }
        long totalTimeOnPath = Math.max(monitorElement1.getTotalTimeOnPath(), monitorElement2.getTotalTimeOnPath());
        MonitorElement mergedElement = new MonitorElement(retElement, totalTimeOnPath);
        return mergedElement;
    }
}

