/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;

public class MonitorPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;
    final Timer totalTimeOfPrecAdj = new Timer();

    public MonitorPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision oldPrecision, UnmodifiableReachedSet pElements) throws CPAException {
        Preconditions.checkArgument((boolean)(pElement instanceof MonitorElement));
        MonitorElement element = (MonitorElement)pElement;
        if (element.getWrappedElement() == MonitorElement.TimeoutElement.INSTANCE) {
            return Triple.of((Object)pElement, (Object)oldPrecision, (Object)((Object)PrecisionAdjustment.Action.CONTINUE));
        }
        UnmodifiableReachedSetView elements = new UnmodifiableReachedSetView(pElements, MonitorElement.getUnwrapFunction(), (Function<? super Precision, Precision>)Functions.identity());
        AbstractElement oldElement = element.getWrappedElement();
        this.totalTimeOfPrecAdj.start();
        Triple<AbstractElement, Precision, PrecisionAdjustment.Action> unwrappedResult = this.wrappedPrecAdjustment.prec(oldElement, oldPrecision, elements);
        long totalTimeOfExecution = this.totalTimeOfPrecAdj.stop();
        long updatedTotalTime = totalTimeOfExecution + element.getTotalTimeOnPath();
        Pair<PreventingHeuristic, Long> preventingCondition = element.getPreventingCondition();
        AbstractElement newElement = (AbstractElement)unwrappedResult.getFirst();
        Precision newPrecision = (Precision)unwrappedResult.getSecond();
        PrecisionAdjustment.Action action = (PrecisionAdjustment.Action)((Object)unwrappedResult.getThird());
        MonitorElement resultElement = new MonitorElement(newElement, updatedTotalTime, preventingCondition);
        return Triple.of((Object)resultElement, (Object)newPrecision, (Object)((Object)action));
    }
}

