/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class MonitorStop
implements StopOperator {
    private final ConfigurableProgramAnalysis wrappedCpa;

    public MonitorStop(ConfigurableProgramAnalysis cpa) {
        this.wrappedCpa = cpa;
    }

    @Override
    public boolean stop(AbstractElement pElement, Collection<AbstractElement> pReached, Precision pPrecision) throws CPAException {
        MonitorElement monitorElement = (MonitorElement)pElement;
        if (monitorElement.mustDumpAssumptionForAvoidance()) {
            return false;
        }
        AbstractElement wrappedElement = monitorElement.getWrappedElement();
        StopOperator stopOp = this.wrappedCpa.getStopOperator();
        for (AbstractElement reachedElement : pReached) {
            MonitorElement monitorReachedElement = (MonitorElement)reachedElement;
            if (monitorReachedElement.mustDumpAssumptionForAvoidance()) {
                return false;
            }
            AbstractElement wrappedReachedElement = monitorReachedElement.getWrappedElement();
            if (!stopOp.stop(wrappedElement, Collections.singleton(wrappedReachedElement), pPrecision)) continue;
            return true;
        }
        return false;
    }
}

