/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.mustmay;

import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.mustmay.MustMayAnalysisDomain;
import org.sosy_lab.cpachecker.cpa.mustmay.MustMayAnalysisElement;
import org.sosy_lab.cpachecker.cpa.mustmay.MustMayAnalysisPrecision;
import org.sosy_lab.cpachecker.cpa.mustmay.MustMayAnalysisTransferRelation;

public class MustMayAnalysisCPA
implements ConfigurableProgramAnalysis {
    MustMayAnalysisDomain mDomain;
    ConfigurableProgramAnalysis mMustCPA;
    ConfigurableProgramAnalysis mMayCPA;
    Precision mPrecision;
    StopOperator mStopOperator;
    MustMayAnalysisTransferRelation mTransferRelation;

    public MustMayAnalysisCPA(ConfigurableProgramAnalysis pMustCPA, ConfigurableProgramAnalysis pMayCPA) {
        assert (pMustCPA != null);
        assert (pMayCPA != null);
        this.mMustCPA = pMustCPA;
        this.mMayCPA = pMayCPA;
        AbstractDomain lMustDomain = this.mMustCPA.getAbstractDomain();
        AbstractDomain lMayDomain = this.mMayCPA.getAbstractDomain();
        this.mDomain = new MustMayAnalysisDomain(lMustDomain, lMayDomain);
        this.mStopOperator = new StopSepOperator(this.mDomain);
        this.mTransferRelation = new MustMayAnalysisTransferRelation(pMustCPA.getTransferRelation(), pMayCPA.getTransferRelation());
    }

    @Override
    public MustMayAnalysisDomain getAbstractDomain() {
        return this.mDomain;
    }

    @Override
    public MustMayAnalysisElement getInitialElement(CFANode pNode) {
        AbstractElement lInitialMustElement = this.mMustCPA.getInitialElement(pNode);
        AbstractElement lInitialMayElement = this.mMayCPA.getInitialElement(pNode);
        return new MustMayAnalysisElement(lInitialMustElement, lInitialMayElement);
    }

    @Override
    public MustMayAnalysisPrecision getInitialPrecision(CFANode pNode) {
        Precision lInitialMustPrecision = this.mMustCPA.getInitialPrecision(pNode);
        Precision lInitialMayPrecision = this.mMayCPA.getInitialPrecision(pNode);
        return new MustMayAnalysisPrecision(lInitialMustPrecision, lInitialMayPrecision);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.mStopOperator;
    }

    @Override
    public MustMayAnalysisTransferRelation getTransferRelation() {
        return this.mTransferRelation;
    }
}

