/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.mustmay;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.mustmay.MustMayAnalysisElement;
import org.sosy_lab.cpachecker.cpa.mustmay.MustMayAnalysisPrecision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class MustMayAnalysisTransferRelation
implements TransferRelation {
    private TransferRelation mMustTransferRelation;
    private TransferRelation mMayTransferRelation;

    public MustMayAnalysisTransferRelation(TransferRelation pMustTransferRelation, TransferRelation pMayTransferRelation) {
        assert (pMustTransferRelation != null);
        assert (pMayTransferRelation != null);
        this.mMustTransferRelation = pMustTransferRelation;
        this.mMayTransferRelation = pMayTransferRelation;
    }

    public Collection<AbstractElement> getAbstractSuccessors(AbstractElement pCurrentElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        assert (pCurrentElement != null);
        assert (pCurrentElement instanceof MustMayAnalysisElement);
        assert (pPrecision != null);
        assert (pPrecision instanceof MustMayAnalysisPrecision);
        assert (pCfaEdge != null);
        MustMayAnalysisElement lCurrentElement = (MustMayAnalysisElement)pCurrentElement;
        AbstractElement lCurrentMayElement = lCurrentElement.getMayElement();
        AbstractElement lCurrentMustElement = lCurrentElement.getMustElement();
        MustMayAnalysisPrecision lPrecision = (MustMayAnalysisPrecision)pPrecision;
        Collection<? extends AbstractElement> lMaySuccessors = this.mMayTransferRelation.getAbstractSuccessors(lCurrentMayElement, lPrecision.getMayPrecision(), pCfaEdge);
        HashSet<AbstractElement> lConsolidatedMaySuccessors = new HashSet<AbstractElement>();
        for (AbstractElement abstractElement : lMaySuccessors) {
            lConsolidatedMaySuccessors.add(abstractElement);
        }
        if (lConsolidatedMaySuccessors.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<Object> lMustSuccessors = Collections.emptySet();
        if (lCurrentMustElement != MustMayAnalysisElement.DONT_KNOW_ELEMENT) {
            lMustSuccessors = this.mMustTransferRelation.getAbstractSuccessors(lCurrentMustElement, lPrecision.getMustPrecision(), pCfaEdge);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(lMustSuccessors);
        if (hashSet.isEmpty()) {
            hashSet.add(MustMayAnalysisElement.DONT_KNOW_ELEMENT);
        }
        HashSet<AbstractElement> lSuccessors = new HashSet<AbstractElement>();
        for (AbstractElement lMaySuccessor : lConsolidatedMaySuccessors) {
            for (AbstractElement abstractElement : hashSet) {
                Collection<? extends AbstractElement> lStrengthenList = this.mMustTransferRelation.strengthen(abstractElement, Collections.singletonList(lMaySuccessor), pCfaEdge, lPrecision.getMustPrecision());
                if (lStrengthenList == null) {
                    lSuccessors.add(new MustMayAnalysisElement(abstractElement, lMaySuccessor));
                    continue;
                }
                if (lStrengthenList.isEmpty()) {
                    lSuccessors.add(new MustMayAnalysisElement(MustMayAnalysisElement.DONT_KNOW_ELEMENT, lMaySuccessor));
                    continue;
                }
                for (AbstractElement abstractElement2 : lStrengthenList) {
                    lSuccessors.add(new MustMayAnalysisElement(abstractElement2, lMaySuccessor));
                }
            }
        }
        return lSuccessors;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        return null;
    }
}

